/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.javax.ws.rs.NotAcceptableException;
import org.apache.hbase.thirdparty.javax.ws.rs.client.Client;
import org.apache.hbase.thirdparty.javax.ws.rs.client.ClientBuilder;
import org.apache.hbase.thirdparty.javax.ws.rs.client.WebTarget;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, LargeTests.class})
public class TestApiV1ClusterMetricsResource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestApiV1ClusterMetricsResource.class);
    private static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setMiniClusterOption(StartMiniClusterOption.builder().numZkServers(3).numMasters(3).numDataNodes(3).build()).setConfiguration(() -> {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.info.port", 0);
        conf.set("hbase.http.jersey.tracing.type", "ON_DEMAND");
        return conf;
    }).build();
    private static final ConnectionRule connectionRule = ConnectionRule.createAsyncConnectionRule(miniClusterRule::createAsyncConnection);
    private static final ClassSetup classRule = new ClassSetup(connectionRule::getAsyncConnection);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)miniClusterRule).around((TestRule)connectionRule).around((TestRule)classRule);

    @Test
    public void testGetRoot() {
        String response = (String)classRule.getTarget().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"\"hbase_version\":"), (Matcher)Matchers.containsString((String)"\"cluster_id\":"), (Matcher)Matchers.containsString((String)"\"master_name\":"), (Matcher)Matchers.containsString((String)"\"backup_master_names\":")));
    }

    @Test
    public void testGetRootHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetLiveServers() {
        String response = (String)classRule.getTarget().path("live_servers").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"{\"data\":["), (Matcher)Matchers.endsWith((String)"]}")));
    }

    @Test
    public void testGetLiveServersHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("live_servers").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetDeadServers() {
        String response = (String)classRule.getTarget().path("dead_servers").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"{\"data\":["), (Matcher)Matchers.endsWith((String)"]}")));
    }

    @Test
    public void testGetDeadServersHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("dead_servers").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    private static final class ClassSetup
    extends ExternalResource {
        private final Supplier<AsyncConnection> connectionSupplier;
        private final TableName tableName;
        private AsyncAdmin admin;
        private WebTarget target;

        public ClassSetup(Supplier<AsyncConnection> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
            this.tableName = TableName.valueOf((String)TestApiV1ClusterMetricsResource.class.getSimpleName());
        }

        public WebTarget getTarget() {
            return this.target;
        }

        protected void before() throws Throwable {
            AsyncConnection conn = this.connectionSupplier.get();
            this.admin = conn.getAdmin();
            TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"c")).build()).setDurability(Durability.SKIP_WAL).build();
            this.admin.createTable(tableDescriptor).get();
            String baseUrl = (String)((CompletableFuture)((CompletableFuture)this.admin.getMaster().thenApply(ServerName::getHostname)).thenCombine((CompletionStage)this.admin.getMasterInfoPort(), (hostName, infoPort) -> "http://" + hostName + ":" + infoPort)).get();
            Client client = ClientBuilder.newClient();
            this.target = client.target(baseUrl).path("api/v1/admin/cluster_metrics");
        }

        protected void after() {
            TableName tableName = TableName.valueOf((String)"test");
            try {
                ((CompletableFuture)this.admin.tableExists(tableName).thenCompose(val -> {
                    if (val.booleanValue()) {
                        return this.admin.disableTable(tableName).thenCompose(ignored -> this.admin.deleteTable(tableName));
                    }
                    return CompletableFuture.completedFuture(null);
                })).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

