/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.shaded.org.joda.time.DateTime;
import org.apache.hadoop.shaded.org.joda.time.LocalDate;
import org.apache.hadoop.shaded.org.joda.time.LocalTime;
import org.apache.hadoop.shaded.org.jsonschema2pojo.GenerationConfig;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.exception.GenerationException;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;

public class FormatRule
implements Rule<JType, JType> {
    public static String ISO_8601_DATE_FORMAT = "yyyy-MM-dd";
    public static String ISO_8601_TIME_FORMAT = "HH:mm:ss.SSS";
    public static String ISO_8601_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private final RuleFactory ruleFactory;
    private final Map<String, Class<?>> formatTypeMapping;

    protected FormatRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
        this.formatTypeMapping = FormatRule.getFormatTypeMapping(ruleFactory.getGenerationConfig());
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JsonNode parent, JType baseType, Schema schema) {
        Class<?> type = this.getType(node.asText());
        if (type != null) {
            JType jtype = baseType.owner().ref(type);
            if (this.ruleFactory.getGenerationConfig().isUsePrimitives()) {
                jtype = ((JType)jtype).unboxify();
            }
            return jtype;
        }
        return baseType;
    }

    private Class<?> getType(String format) {
        return this.formatTypeMapping.getOrDefault(format, null);
    }

    private static Map<String, Class<?>> getFormatTypeMapping(GenerationConfig config) {
        HashMap mapping = new HashMap(14);
        mapping.put("date-time", FormatRule.getDateTimeType(config));
        mapping.put("date", FormatRule.getDateType(config));
        mapping.put("time", FormatRule.getTimeType(config));
        mapping.put("utc-millisec", Long.class);
        mapping.put("regex", Pattern.class);
        mapping.put("color", String.class);
        mapping.put("style", String.class);
        mapping.put("phone", String.class);
        mapping.put("uri", URI.class);
        mapping.put("email", String.class);
        mapping.put("ip-address", String.class);
        mapping.put("ipv6", String.class);
        mapping.put("host-name", String.class);
        mapping.put("uuid", UUID.class);
        for (Map.Entry<String, String> override : config.getFormatTypeMapping().entrySet()) {
            String format = override.getKey();
            Class<?> type = FormatRule.tryLoadType(override.getValue(), format);
            if (type == null) continue;
            mapping.put(format, type);
        }
        return mapping;
    }

    private static Class<?> getDateTimeType(GenerationConfig config) {
        Class<?> type = FormatRule.tryLoadType(config.getDateTimeType(), "data-time");
        if (type != null) {
            return type;
        }
        return config.isUseJodaDates() ? DateTime.class : Date.class;
    }

    private static Class<?> getDateType(GenerationConfig config) {
        Class<?> type = FormatRule.tryLoadType(config.getDateType(), "data");
        if (type != null) {
            return type;
        }
        return config.isUseJodaLocalDates() ? LocalDate.class : String.class;
    }

    private static Class<?> getTimeType(GenerationConfig config) {
        Class<?> type = FormatRule.tryLoadType(config.getTimeType(), "time");
        if (type != null) {
            return type;
        }
        return config.isUseJodaLocalTimes() ? LocalTime.class : String.class;
    }

    private static Class<?> tryLoadType(String typeName, String format) {
        if (!StringUtils.isEmpty(typeName)) {
            try {
                Class type = ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)typeName);
                return type;
            }
            catch (ClassNotFoundException e) {
                throw new GenerationException(String.format("could not load java type %s for %s", typeName, format), e);
            }
        }
        return null;
    }
}

