/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.messaging.TopicDTO;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericTopic
implements Topic,
SupportsTags,
SupportsRoles,
SupportsPolicies {
    private final TopicDTO topicDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectRoleOperations objectRoleOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;

    GenericTopic(TopicDTO topicDTO, RESTClient restClient, Namespace topicNs) {
        this.topicDTO = topicDTO;
        ArrayList topicFullName = Lists.newArrayList((Object[])new String[]{topicNs.level(1), topicNs.level(2), topicDTO.name()});
        MetadataObject topicObject = MetadataObjects.of((List)topicFullName, (MetadataObject.Type)MetadataObject.Type.TOPIC);
        this.objectTagOperations = new MetadataObjectTagOperations(topicNs.level(0), topicObject, restClient);
        this.objectRoleOperations = new MetadataObjectRoleOperations(topicNs.level(0), topicObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(topicNs.level(0), topicObject, restClient);
    }

    public Audit auditInfo() {
        return this.topicDTO.auditInfo();
    }

    public String name() {
        return this.topicDTO.name();
    }

    public String comment() {
        return this.topicDTO.comment();
    }

    public Map<String, String> properties() {
        return this.topicDTO.properties();
    }

    public SupportsTags supportsTags() {
        return this;
    }

    public SupportsPolicies supportsPolicies() {
        return this;
    }

    public SupportsRoles supportsRoles() {
        return this;
    }

    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }

    public String[] listBindingRoleNames() {
        return this.objectRoleOperations.listBindingRoleNames();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericTopic)) {
            return false;
        }
        GenericTopic that = (GenericTopic)obj;
        return this.topicDTO.equals((Object)that.topicDTO);
    }

    public int hashCode() {
        return this.topicDTO.hashCode();
    }

    public String toString() {
        return "GenericTopic{topicDTO=" + this.topicDTO.toString() + "}";
    }
}

