/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.ArrayUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SeqReverseFunction
extends AbstractFunction {
    private static final long serialVersionUID = 784309776347529069L;
    public static final SeqReverseFunction INSTANCE = new SeqReverseFunction();

    private SeqReverseFunction() {
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Object first = arg1.getValue(env);
        if (first == null) {
            return AviatorNil.NIL;
        }
        Class<?> clazz = first.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)first;
            Collections.reverse(list);
            return arg1;
        }
        if (clazz.isArray()) {
            int length = ArrayUtils.getLength(first);
            for (int i = 0; i < length / 2; ++i) {
                Object temp = ArrayUtils.get(first, i);
                ArrayUtils.set(first, i, ArrayUtils.get(first, length - 1 - i));
                ArrayUtils.set(first, length - 1 - i, temp);
            }
            return arg1;
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not an array or list.");
    }

    @Override
    public String getName() {
        return "reverse";
    }
}

