/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.apache.gravitino.abs.credential;

import org.apache.gravitino.credential.ADLSTokenCredential;
import org.apache.gravitino.credential.CredentialProviderDelegator;

/**
 * A lightweight credential provider for ADLS. It delegates the actual credential generation to
 * {@link ADLSTokenGenerator} which is loaded via reflection to avoid classpath issues.
 */
public class ADLSTokenProvider extends CredentialProviderDelegator<ADLSTokenCredential> {

  @Override
  public String credentialType() {
    return ADLSTokenCredential.ADLS_TOKEN_CREDENTIAL_TYPE;
  }

  @Override
  public String getGeneratorClassName() {
    return "org.apache.gravitino.abs.credential.ADLSTokenGenerator";
  }
}
