/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.TableColumnBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.TableColumnPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class TableColumnSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, TableColumnBaseSQLProvider> TABLE_COLUMN_SQL_PROVIDERS = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new TableColumnMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new TableColumnH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new TableColumnPostgreSQLProvider());

    public static TableColumnBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return TABLE_COLUMN_SQL_PROVIDERS.get((Object)jdbcBackendType);
    }

    public static String listColumnPOsByTableIdAndVersion(@Param(value="tableId") Long tableId, @Param(value="tableVersion") Long tableVersion) {
        return TableColumnSQLProviderFactory.getProvider().listColumnPOsByTableIdAndVersion(tableId, tableVersion);
    }

    public static String insertColumnPOs(@Param(value="columnPOs") List<ColumnPO> columnPOs) {
        return TableColumnSQLProviderFactory.getProvider().insertColumnPOs(columnPOs);
    }

    public static String updateSchemaIdByTableId(@Param(value="tableId") Long tableId, @Param(value="newSchemaId") Long newSchemaId) {
        return TableColumnSQLProviderFactory.getProvider().updateSchemaIdByTableId(tableId, newSchemaId);
    }

    public static String softDeleteColumnsByTableId(@Param(value="tableId") Long tableId) {
        return TableColumnSQLProviderFactory.getProvider().softDeleteColumnsByTableId(tableId);
    }

    public static String deleteColumnPOsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return TableColumnSQLProviderFactory.getProvider().deleteColumnPOsByLegacyTimeline(legacyTimeline, limit);
    }

    public static String softDeleteColumnsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return TableColumnSQLProviderFactory.getProvider().softDeleteColumnsByMetalakeId(metalakeId);
    }

    public static String softDeleteColumnsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return TableColumnSQLProviderFactory.getProvider().softDeleteColumnsByCatalogId(catalogId);
    }

    public static String softDeleteColumnsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return TableColumnSQLProviderFactory.getProvider().softDeleteColumnsBySchemaId(schemaId);
    }

    public static String selectColumnIdByTableIdAndName(@Param(value="tableId") Long tableId, @Param(value="columnName") String name) {
        return TableColumnSQLProviderFactory.getProvider().selectColumnIdByTableIdAndName(tableId, name);
    }

    public static String selectColumnPOById(@Param(value="columnId") Long columnId) {
        return TableColumnSQLProviderFactory.getProvider().selectColumnPOById(columnId);
    }

    public static String listColumnPOsByColumnIds(@Param(value="columnIds") List<Long> columnIds) {
        return TableColumnSQLProviderFactory.getProvider().listColumnPOsByColumnIds(columnIds);
    }

    static class TableColumnMySQLProvider
    extends TableColumnBaseSQLProvider {
        TableColumnMySQLProvider() {
        }
    }

    static class TableColumnH2Provider
    extends TableColumnBaseSQLProvider {
        TableColumnH2Provider() {
        }
    }
}

