/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.utils.FixLenByteArrayOutputStream;
import org.apache.paimon.utils.ThreadUtils;

public class AsyncPositionOutputStream
extends PositionOutputStream {
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(ThreadUtils.newDaemonThreadFactory((String)"AsyncOutputStream"));
    public static final int AWAIT_TIMEOUT_SECONDS = 10;
    public static final int BUFFER_SIZE = 65536;
    public static final int MAX_BUFFER = 1024;
    private final PositionOutputStream out;
    private final FixLenByteArrayOutputStream buffer;
    private final LinkedBlockingQueue<byte[]> bufferQueue;
    private final LinkedBlockingQueue<AsyncEvent> eventQueue;
    private final AtomicReference<Throwable> exception;
    private final Future<?> future;
    private int totalBuffers;
    private long position;
    private boolean closed = false;

    public AsyncPositionOutputStream(PositionOutputStream out) {
        this.out = out;
        this.bufferQueue = new LinkedBlockingQueue();
        this.eventQueue = new LinkedBlockingQueue();
        this.exception = new AtomicReference();
        this.position = 0L;
        this.future = EXECUTOR_SERVICE.submit(this::execute);
        this.buffer = new FixLenByteArrayOutputStream();
        this.buffer.setBuffer(new byte[65536]);
        this.totalBuffers = 1;
    }

    @VisibleForTesting
    LinkedBlockingQueue<byte[]> getBufferQueue() {
        return this.bufferQueue;
    }

    private void execute() {
        try {
            this.doWork();
        }
        catch (Throwable e) {
            this.exception.set(e);
            throw new RuntimeException(e);
        }
    }

    private void doWork() throws InterruptedException, IOException {
        try {
            while (true) {
                AsyncEvent event;
                if ((event = this.eventQueue.poll(10L, TimeUnit.SECONDS)) == null) {
                    continue;
                }
                if (event instanceof EndEvent) {
                    return;
                }
                if (event instanceof DataEvent) {
                    DataEvent dataEvent = (DataEvent)event;
                    this.out.write(dataEvent.data, 0, dataEvent.length);
                    this.bufferQueue.add(dataEvent.data);
                }
                if (!(event instanceof FlushEvent)) continue;
                this.out.flush();
                ((FlushEvent)event).latch.countDown();
            }
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public long getPos() throws IOException {
        this.checkException();
        return this.position;
    }

    /*
     * Exception decompiling
     */
    private void flushBuffer() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void write(int b) throws IOException {
        this.checkException();
        ++this.position;
        while (this.buffer.write((byte)b) != 1) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkException();
        this.position += (long)len;
        while (true) {
            int written = this.buffer.write(b, off, len);
            off += written;
            if ((len -= written) == 0) {
                return;
            }
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.checkException();
        this.flushBuffer();
        FlushEvent event = new FlushEvent();
        this.putEvent(event);
        try {
            while (true) {
                boolean await;
                if (await = event.latch.await(10L, TimeUnit.SECONDS)) {
                    return;
                }
                this.checkException();
            }
        }
        catch (InterruptedException e) {
            this.sendEndEvent();
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.checkException();
        this.flushBuffer();
        this.sendEndEvent();
        try {
            this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.bufferQueue.clear();
        this.closed = true;
    }

    private void sendEndEvent() {
        this.putEvent(new EndEvent());
    }

    private void putEvent(AsyncEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void checkException() throws IOException {
        Throwable throwable = this.exception.get();
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(throwable);
        }
    }

    private static class EndEvent
    implements AsyncEvent {
        private EndEvent() {
        }
    }

    private static class FlushEvent
    implements AsyncEvent {
        private final CountDownLatch latch = new CountDownLatch(1);

        private FlushEvent() {
        }
    }

    private static class DataEvent
    implements AsyncEvent {
        private final byte[] data;
        private final int length;

        public DataEvent(byte[] data, int length) {
            this.data = data;
            this.length = length;
        }
    }

    private static interface AsyncEvent {
    }
}

