/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.ListBulkLoader;
import org.apache.paimon.lookup.ListState;
import org.apache.paimon.lookup.memory.InMemoryState;

public class InMemoryListState<K, V>
extends InMemoryState<K, V>
implements ListState<K, V> {
    private final Map<ByteArray, List<byte[]>> values = new HashMap<ByteArray, List<byte[]>>();

    public InMemoryListState(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
    }

    @Override
    public void add(K key, V value) throws IOException {
        byte[] keyBytes = this.serializeKey(key);
        byte[] valueBytes = this.serializeValue(value);
        this.values.computeIfAbsent(ByteArray.wrapBytes(keyBytes), k -> new ArrayList()).add(valueBytes);
    }

    @Override
    public List<V> get(K key) throws IOException {
        List<byte[]> list = this.values.get(ByteArray.wrapBytes(this.serializeKey(key)));
        ArrayList result = new ArrayList();
        if (list != null) {
            for (byte[] value : list) {
                result.add(this.deserializeValue(value));
            }
        }
        return result;
    }

    @Override
    public ListBulkLoader createBulkLoader() {
        return new ListBulkLoader(){

            @Override
            public void write(byte[] key, List<byte[]> value) {
                InMemoryListState.this.values.put(ByteArray.wrapBytes(key), new ArrayList<byte[]>(value));
            }

            @Override
            public void finish() {
            }
        };
    }
}

