/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public final class Blob {
    private final String type;
    private final List<Integer> inputFields;
    private final long snapshotId;
    private final long sequenceNumber;
    private final ByteBuffer blobData;
    private final PuffinCompressionCodec requestedCompression;
    private final Map<String, String> properties;

    public Blob(String type, List<Integer> inputFields, long snapshotId, long sequenceNumber, ByteBuffer blobData) {
        this(type, inputFields, snapshotId, sequenceNumber, blobData, null, (Map<String, String>)ImmutableMap.of());
    }

    public Blob(String type, List<Integer> inputFields, long snapshotId, long sequenceNumber, ByteBuffer blobData, @Nullable PuffinCompressionCodec requestedCompression, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(inputFields, (Object)"inputFields is null");
        Preconditions.checkNotNull((Object)blobData, (Object)"blobData is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.type = type;
        this.inputFields = ImmutableList.copyOf(inputFields);
        this.snapshotId = snapshotId;
        this.sequenceNumber = sequenceNumber;
        this.blobData = blobData;
        this.requestedCompression = requestedCompression;
        this.properties = ImmutableMap.copyOf(properties);
    }

    public String type() {
        return this.type;
    }

    public List<Integer> inputFields() {
        return this.inputFields;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public ByteBuffer blobData() {
        return this.blobData;
    }

    @Nullable
    public PuffinCompressionCodec requestedCompression() {
        return this.requestedCompression;
    }

    public Map<String, String> properties() {
        return this.properties;
    }
}

