/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.ObjectStreamException;
import java.time.temporal.ChronoUnit;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.SerializationProxies;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Months<T>
extends TimeTransform<T> {
    private static final Months<?> INSTANCE = new Months();

    static <T> Months<T> get() {
        return INSTANCE;
    }

    @Override
    protected ChronoUnit granularity() {
        return ChronoUnit.MONTHS;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        return Months.fromSourceType(type, Dates.MONTH, Timestamps.MICROS_TO_MONTH, Timestamps.NANOS_TO_MONTH);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public String toHumanString(Type alwaysInt, Integer value) {
        return value != null ? TransformUtil.humanMonth(value) : "null";
    }

    public String toString() {
        return "month";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.MonthsTransformProxy.get();
    }
}

