/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.authorization.GroupDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class GroupListResponse
extends BaseResponse {
    @JsonProperty(value="groups")
    private final GroupDTO[] groups;

    public GroupListResponse(GroupDTO[] groups) {
        super(0);
        this.groups = groups;
    }

    public GroupListResponse() {
        this.groups = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.groups != null ? 1 : 0) != 0, (Object)"groups must not be null");
        Arrays.stream(this.groups).forEach(group -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)group.name()), (Object)"group 'name' must not be blank");
            Preconditions.checkArgument((group.auditInfo() != null ? 1 : 0) != 0, (Object)"group 'auditInfo' must not be null");
        });
    }

    public GroupDTO[] getGroups() {
        return this.groups;
    }

    @Override
    public String toString() {
        return "GroupListResponse(groups=" + Arrays.deepToString(this.getGroups()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupListResponse)) {
            return false;
        }
        GroupListResponse other = (GroupListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getGroups(), other.getGroups());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GroupListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getGroups());
        return result;
    }
}

