/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.model.Model;

@DeveloperApi
public class ModelInfo {
    private final String name;
    private final Map<String, String> properties;
    private final Optional<String> comment;
    private final Optional<Audit> audit;
    private final Optional<Integer> lastVersion;

    public ModelInfo(Model model) {
        this(model.name(), model.properties(), model.comment(), model.auditInfo(), model.latestVersion());
    }

    public ModelInfo(String name, Map<String, String> properties, String comment) {
        this(name, properties, comment, null, null);
    }

    public ModelInfo(String name, Map<String, String> properties, String comment, Audit audit, Integer lastVersion) {
        this.name = name;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.comment = Optional.ofNullable(comment);
        this.audit = Optional.ofNullable(audit);
        this.lastVersion = Optional.ofNullable(lastVersion);
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Optional<String> comment() {
        return this.comment;
    }

    public Optional<Audit> audit() {
        return this.audit;
    }

    public Optional<Integer> lastVersion() {
        return this.lastVersion;
    }
}

