/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.taglib;

import grails.util.Environment;
import groovy.lang.Binding;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.taglib.AbstractTemplateVariableBinding;
import org.grails.web.servlet.mvc.GrailsWebRequest;

public class WebRequestTemplateVariableBinding
extends AbstractTemplateVariableBinding {
    private static Log log = LogFactory.getLog(WebRequestTemplateVariableBinding.class);
    private GrailsWebRequest webRequest;
    private boolean developmentMode = Environment.isDevelopmentMode();
    private Set<String> requestAttributeVariables = new HashSet<String>();
    private static Map<String, LazyRequestBasedValue> lazyRequestBasedValuesMap;

    public WebRequestTemplateVariableBinding(GrailsWebRequest webRequest) {
        this.webRequest = webRequest;
    }

    @Override
    public Binding findBindingForVariable(String name) {
        Binding binding = super.findBindingForVariable(name);
        if (binding == null && this.webRequest.getCurrentRequest().getAttribute(name) != null) {
            this.requestAttributeVariables.add(name);
            binding = this;
        }
        if (binding == null && lazyRequestBasedValuesMap.containsKey(name)) {
            binding = this;
        }
        return binding;
    }

    public boolean isRequestAttributeVariable(String name) {
        return this.requestAttributeVariables.contains(name);
    }

    @Override
    public boolean isVariableCachingAllowed(String name) {
        return !this.isRequestAttributeVariable(name);
    }

    @Override
    public Object getVariable(String name) {
        Object val = this.getVariablesMap().get(name);
        if (val == null && !this.getVariablesMap().containsKey(name) && this.webRequest != null) {
            val = this.webRequest.getCurrentRequest().getAttribute(name);
            if (val != null) {
                this.requestAttributeVariables.add(name);
            } else {
                LazyRequestBasedValue lazyValue = lazyRequestBasedValuesMap.get(name);
                val = lazyValue != null ? lazyValue.evaluate(this.webRequest) : this.resolveMissingVariable(name);
                if (val == null && this.developmentMode && log.isDebugEnabled()) {
                    log.debug("Variable '" + name + "' not found in binding or the value is null.");
                }
            }
        }
        return val;
    }

    protected Object resolveMissingVariable(String name) {
        return null;
    }

    @Override
    public Set<String> getVariableNames() {
        if (this.getVariablesMap().isEmpty()) {
            return lazyRequestBasedValuesMap.keySet();
        }
        HashSet<String> variableNames = new HashSet<String>(lazyRequestBasedValuesMap.keySet());
        variableNames.addAll(this.getVariablesMap().keySet());
        return variableNames;
    }

    static {
        Map<String, LazyRequestBasedValue> m = lazyRequestBasedValuesMap = new HashMap<String, LazyRequestBasedValue>();
        m.put("webRequest", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest;
            }
        });
        m.put("request", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getCurrentRequest();
            }
        });
        m.put("response", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getCurrentResponse();
            }
        });
        m.put("flash", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getFlashScope();
            }
        });
        m.put("application", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getServletContext();
            }
        });
        m.put("applicationContext", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getAttributes().getApplicationContext();
            }
        });
        m.put("grailsApplication", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getAttributes().getGrailsApplication();
            }
        });
        m.put("session", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getSession();
            }
        });
        m.put("params", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getParams();
            }
        });
        m.put("actionName", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getActionName();
            }
        });
        m.put("namespace", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getControllerNamespace();
            }
        });
        m.put("controllerName", new LazyRequestBasedValue(){

            @Override
            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getControllerName();
            }
        });
    }

    private static interface LazyRequestBasedValue {
        public Object evaluate(GrailsWebRequest var1);
    }
}

