/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.gobblin.broker.iface;

/**
 * A key to differentiate objects generated by the same factory for a {@link SharedResourcesBroker}. The
 * {@link SharedResourcesBroker} is guaranteed to return the same object for the same factory, {@link ScopeInstance},
 * and {@link SharedResourceKey}, but different objects if any of this differ. The key can contain information relevant
 * to the factory.
 *
 * Note: keys are compared using {@link #equals(Object)}. It is important for implementations to override this method.
 *
 * Example: for a file handle factory, the key could specify the path of the file for which the handle is needed.
 */
public interface SharedResourceKey {

  /**
   * @return A serialization of the {@link SharedResourceKey} into a short, sanitized string. Users configure a
   *         shared resource using the value of this method.
   */
  String toConfigurationKey();

}
