/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.gobblin.eventhub;

/**
 * Contains names for all metrics generated by eventhub component
 */
public class EventhubMetricNames {

  public static class EventhubDataWriterMetrics {

    /**
     * A {@link com.codahale.metrics.Meter} measuring the number of records attempted
     * to be written by a {@link org.apache.gobblin.eventhub.writer.EventhubDataWriter}. This includes retries.
     */
    public static final String RECORDS_ATTEMPTED_METER = "eventhub.writer.records.attempted";

    /**
     * A {@link com.codahale.metrics.Meter} measuring the number records written by a {@link org.apache.gobblin.eventhub.writer.EventhubDataWriter}
     */
    public static final String RECORDS_SUCCESS_METER = "eventhub.writer.records.success";

    /** A {@link com.codahale.metrics.Meter} measuring the number of records
     * given to a {@link org.apache.gobblin.eventhub.writer.EventhubDataWriter}. This does not count retries.
     */
    public static final String RECORDS_FAILED_METER = "eventhub.writer.records.failed";

    /**
     * A {@link com.codahale.metrics.Meter} measuring the number bytes written by a {@link org.apache.gobblin.eventhub.writer.EventhubDataWriter} as
     */
    public static final String BYTES_WRITTEN_METER = "eventhub.writer.bytes.written";

    /**
     * A {@link com.codahale.metrics.Timer} measuring the time taken for each write operation.
     */
    public static final String WRITE_TIMER = "eventhub.writer.write.time";
  }
}
