/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectionUtils {
    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    private static Type walkParentsTypeChain(Class<?> target, Class<?> rawType, Map<Type, Type> resolvedTypes) {
        Type result = ReflectionUtils.walkTypeChain(target, rawType.getGenericSuperclass(), resolvedTypes);
        if (result != null) {
            return result;
        }
        for (Type t : rawType.getGenericInterfaces()) {
            result = ReflectionUtils.walkTypeChain(target, t, resolvedTypes);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Type walkTypeChain(Class<?> target, Type type, Map<Type, Type> resolvedTypes) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            Type result = ReflectionUtils.walkParentsTypeChain(target, (Class)type, resolvedTypes);
            if (result != null) {
                return result;
            }
        } else {
            ReflectionUtils.mapTypeParameters((ParameterizedType)type, resolvedTypes);
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            if (rawType.equals(target)) {
                return type;
            }
            Type result = ReflectionUtils.walkParentsTypeChain(target, rawType, resolvedTypes);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private static void mapTypeParameters(ParameterizedType type, Map<Type, Type> resolvedTypes) {
        Class rawType = (Class)type.getRawType();
        Type[] actualTypeArguments = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
        }
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        List<Type> typeArguments = ReflectionUtils.getTypeArgumentsParametrized(baseClass, childClass);
        ArrayList rawTypeArguments = null;
        if (typeArguments != null) {
            rawTypeArguments = new ArrayList();
            for (Type type : typeArguments) {
                rawTypeArguments.add(ReflectionUtils.getClass(type));
            }
        }
        return rawTypeArguments;
    }

    public static <T> List<Type> getTypeArgumentsParametrized(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type type = ReflectionUtils.walkTypeChain(baseClass, childClass, resolvedTypes);
        if (type == null) {
            return null;
        }
        Type[] typeArguments = type instanceof Class ? ((Class)type).getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList<Type> typeArgumentsAsClasses = new ArrayList<Type>();
        for (Type baseType : typeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(baseType);
        }
        return typeArgumentsAsClasses;
    }
}

