/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.util;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DynamicRecordMetadata;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.ResourceSpecImpl;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionSchemaArray;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssocKeySchema;
import com.linkedin.restli.restspec.AssocKeySchemaArray;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.IdentifierSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.util.CustomTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceSchemaToResourceSpecTranslator {
    private final DataSchemaResolver _schemaResolver;
    private final ClassBindingResolver _bindingResolver;

    public ResourceSchemaToResourceSpecTranslator(DataSchemaResolver schemaResolver, ClassBindingResolver bindingResolver) {
        this._schemaResolver = schemaResolver;
        this._bindingResolver = bindingResolver;
    }

    public ResourceSpec translate(ResourceSchema resourceSchema) {
        if (resourceSchema.hasCollection()) {
            CollectionSchema collection = resourceSchema.getCollection();
            return this.collectionToResourceSpec(resourceSchema, collection);
        }
        if (resourceSchema.hasAssociation()) {
            AssociationSchema association = resourceSchema.getAssociation();
            return this.associationToResourceSpec(resourceSchema, association);
        }
        if (resourceSchema.hasActionsSet()) {
            ActionsSetSchema actionsSet = resourceSchema.getActionsSet();
            return this.actionSetToResourceSpec(actionsSet);
        }
        if (resourceSchema.hasSimple()) {
            SimpleSchema simple = resourceSchema.getSimple();
            return this.simpleToResourceSpec(resourceSchema, simple);
        }
        throw new IllegalStateException("ResourceSchema does not have any of the recognized types (collection, association, actionSet, simple), exactly one is required.");
    }

    private ResourceSpec collectionToResourceSpec(ResourceSchema resourceSchema, CollectionSchema collection) {
        ActionSchemaArray actions = null;
        ActionSchemaArray entityActions = null;
        StringArray supports = collection.getSupports();
        if (collection.hasActions()) {
            actions = collection.getActions();
        }
        if (collection.getEntity().hasActions()) {
            entityActions = collection.getEntity().getActions();
        }
        String schema = resourceSchema.getSchema();
        IdentifierSchema identifier = collection.getIdentifier();
        if (identifier.getParams() == null) {
            DataSchema key = RestSpecCodec.textToSchema(identifier.getType(), this._schemaResolver);
            return this.buildResourceSpec(supports, this.toTypeSpec(key), null, Collections.emptyMap(), schema, actions, entityActions);
        }
        DataSchema keyKeyType = RestSpecCodec.textToSchema(identifier.getType(), this._schemaResolver);
        DataSchema keyParamsType = RestSpecCodec.textToSchema(identifier.getParams(), this._schemaResolver);
        ComplexKeySpec<?, ?> complexKeyType = this.toComplexKey(keyKeyType, keyParamsType);
        return this.buildResourceSpec(supports, new TypeSpec<ComplexResourceKey>(ComplexResourceKey.class, null), complexKeyType, Collections.emptyMap(), schema, actions, entityActions);
    }

    private ResourceSpec associationToResourceSpec(ResourceSchema resourceSchema, AssociationSchema association) {
        ActionSchemaArray actions = null;
        ActionSchemaArray entityActions = null;
        StringArray supports = association.getSupports();
        if (association.hasActions()) {
            actions = association.getActions();
        }
        if (association.getEntity().hasActions()) {
            entityActions = association.getEntity().getActions();
        }
        String schema = resourceSchema.getSchema();
        AssocKeySchemaArray assocKeys = association.getAssocKeys();
        HashMap<String, CompoundKey.TypeInfo> keyParts = new HashMap<String, CompoundKey.TypeInfo>();
        Iterator iterator = assocKeys.iterator();
        while (iterator.hasNext()) {
            AssocKeySchema assocKey = (AssocKeySchema)((Object)iterator.next());
            TypeSpec<?> type = this.toTypeSpec(RestSpecCodec.textToSchema(assocKey.getType(), this._schemaResolver));
            keyParts.put(assocKey.getName(), new CompoundKey.TypeInfo(type, type));
        }
        return this.buildResourceSpec(supports, new TypeSpec<CompoundKey>(CompoundKey.class, null), null, keyParts, schema, actions, entityActions);
    }

    private ResourceSpec actionSetToResourceSpec(ActionsSetSchema actionsSet) {
        ActionSchemaArray actions = null;
        if (actionsSet.hasActions()) {
            actions = actionsSet.getActions();
        }
        return this.buildResourceSpec(new StringArray(0), new TypeSpec<Void>(Void.class), null, Collections.emptyMap(), null, actions, null);
    }

    private ResourceSpec simpleToResourceSpec(ResourceSchema resourceSchema, SimpleSchema simple) {
        ActionSchemaArray entityActions = null;
        StringArray supports = simple.getSupports();
        if (simple.hasActions()) {
            entityActions = simple.getActions();
        }
        String schema = resourceSchema.getSchema();
        return this.buildResourceSpec(supports, null, null, Collections.emptyMap(), schema, null, entityActions);
    }

    private ResourceSpec buildResourceSpec(StringArray supports, TypeSpec<?> key, ComplexKeySpec<?, ?> complexKeyType, Map<String, ?> keyParts, String entitySchemaString, ActionSchemaArray actions, ActionSchemaArray entityActions) {
        Set<ResourceMethod> supportedMethods = this.toResourceMethods(supports);
        ActionCollectionMetadata actionCollectionMetadata = this.toDynamicRecordMetadata(actions, entityActions);
        Map<String, DynamicRecordMetadata> actionRequestMetadata = actionCollectionMetadata._request;
        Map<String, DynamicRecordMetadata> actionResponseMetadata = actionCollectionMetadata._response;
        DataSchema entitySchema = entitySchemaString == null ? null : RestSpecCodec.textToSchema(entitySchemaString, this._schemaResolver);
        TypeSpec<? extends RecordTemplate> value = this.toValueType(entitySchema);
        return new ResourceSpecImpl(supportedMethods, actionRequestMetadata, actionResponseMetadata, key, complexKeyType, value, keyParts);
    }

    private Set<ResourceMethod> toResourceMethods(StringArray supports) {
        if (supports == null) {
            return Collections.emptySet();
        }
        HashSet<ResourceMethod> resourceMethods = new HashSet<ResourceMethod>();
        for (String method : supports) {
            resourceMethods.add(ResourceMethod.fromString(method));
        }
        return resourceMethods;
    }

    private ActionCollectionMetadata toDynamicRecordMetadata(ActionSchemaArray actions, ActionSchemaArray entityActions) {
        ActionSchemaArray[] actionGroups;
        HashMap<String, DynamicRecordMetadata> response = new HashMap<String, DynamicRecordMetadata>();
        HashMap<String, DynamicRecordMetadata> request = new HashMap<String, DynamicRecordMetadata>();
        for (ActionSchemaArray actionGroup : actionGroups = new ActionSchemaArray[]{actions, entityActions}) {
            if (actionGroup == null) continue;
            Iterator iterator = actionGroup.iterator();
            while (iterator.hasNext()) {
                ActionSchema action = (ActionSchema)((Object)iterator.next());
                ActionMetadata metadata = this.toActionMetadata(action);
                request.put(metadata._name, metadata._request);
                response.put(metadata._name, metadata._response);
            }
        }
        return new ActionCollectionMetadata(request, response);
    }

    private ActionMetadata toActionMetadata(ActionSchema action) {
        List<Object> response;
        ArrayList<FieldDef> fieldDefs = new ArrayList<FieldDef>();
        if (action.hasParameters()) {
            Iterator iterator = action.getParameters().iterator();
            while (iterator.hasNext()) {
                ParameterSchema parameterSchema = (ParameterSchema)((Object)iterator.next());
                DataSchema dataSchema = RestSpecCodec.textToSchema(parameterSchema.getType(), this._schemaResolver);
                Class<?> paramClass = this.toType(dataSchema);
                FieldDef fieldDef = new FieldDef(parameterSchema.getName(), paramClass, dataSchema);
                fieldDefs.add(fieldDef);
            }
        }
        if (action.hasReturns()) {
            DataSchema returnType = RestSpecCodec.textToSchema(action.getReturns(), this._schemaResolver);
            Class<?> returnClass = this.toType(returnType);
            response = Collections.singletonList(new FieldDef("value", returnClass, returnType));
        } else {
            response = Collections.emptyList();
        }
        return new ActionMetadata(action.getName(), new DynamicRecordMetadata(action.getName(), fieldDefs), new DynamicRecordMetadata(action.getName(), response));
    }

    private TypeSpec<?> toTypeSpec(DataSchema schema) {
        return new TypeSpec(this.toType(schema), schema.getDereferencedDataSchema());
    }

    public Class<?> toType(DataSchema schema) {
        Class javaClass;
        if (schema.getType() == DataSchema.Type.TYPEREF && (javaClass = CustomTypeUtil.getJavaCustomTypeClassFromSchema((DataSchema)((TyperefDataSchema)schema))) != null) {
            return javaClass;
        }
        DataSchema.Type dereferencedType = schema.getDereferencedType();
        DataSchema dereferencedDataSchema = schema.getDereferencedDataSchema();
        if (dereferencedDataSchema.isPrimitive()) {
            return DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)dereferencedType);
        }
        if (dereferencedDataSchema instanceof EnumDataSchema) {
            return this._bindingResolver.resolveEnumClass((EnumDataSchema)dereferencedDataSchema);
        }
        return this._bindingResolver.resolveTemplateClass(dereferencedDataSchema);
    }

    public ComplexKeySpec<?, ?> toComplexKey(DataSchema keyDataSchema, DataSchema paramsDataSchema) {
        TypeSpec<? extends RecordTemplate> complexKeyKey = this.toRecordTemplateType(keyDataSchema);
        TypeSpec<? extends RecordTemplate> complexKeyParams = this.toRecordTemplateType(paramsDataSchema);
        return new ComplexKeySpec<RecordTemplate, RecordTemplate>(complexKeyKey, complexKeyParams);
    }

    public TypeSpec<? extends RecordTemplate> toValueType(DataSchema schema) {
        return this.toRecordTemplateType(schema);
    }

    private TypeSpec<? extends RecordTemplate> toRecordTemplateType(DataSchema schema) {
        if (schema == null) {
            return null;
        }
        return new TypeSpec<DataTemplate>(this._bindingResolver.resolveTemplateClass(schema), schema);
    }

    private static class ActionMetadata {
        public String _name;
        public DynamicRecordMetadata _response;
        public DynamicRecordMetadata _request;

        public ActionMetadata(String name, DynamicRecordMetadata request, DynamicRecordMetadata response) {
            this._name = name;
            this._request = request;
            this._response = response;
        }
    }

    private static class ActionCollectionMetadata {
        public Map<String, DynamicRecordMetadata> _response;
        public Map<String, DynamicRecordMetadata> _request;

        public ActionCollectionMetadata(Map<String, DynamicRecordMetadata> request, Map<String, DynamicRecordMetadata> response) {
            this._request = request;
            this._response = response;
        }
    }

    public static interface ClassBindingResolver {
        public Class<? extends DataTemplate> resolveTemplateClass(DataSchema var1);

        public Class<? extends Enum> resolveEnumClass(EnumDataSchema var1);
    }
}

