/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.policy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.runtime.api.FlowEdge;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.service.modules.policy.ServicePolicy;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="static")
public class StaticServicePolicy
implements ServicePolicy {
    private static final Logger log = LoggerFactory.getLogger(StaticServicePolicy.class);
    Set<FlowEdge> blacklistedEdges;
    List<ServiceNode> serviceNodes;
    List<FlowEdge> flowEdges;

    public StaticServicePolicy() {
        this.serviceNodes = new ArrayList<ServiceNode>();
        this.flowEdges = new ArrayList<FlowEdge>();
        this.blacklistedEdges = new HashSet<FlowEdge>();
    }

    public StaticServicePolicy(List<ServiceNode> serviceNodes, List<FlowEdge> flowEdges) {
        Preconditions.checkNotNull(serviceNodes);
        Preconditions.checkNotNull(flowEdges);
        this.blacklistedEdges = new HashSet<FlowEdge>();
        this.serviceNodes = serviceNodes;
        this.flowEdges = flowEdges;
    }

    @Override
    public void addServiceNode(ServiceNode serviceNode) {
        this.serviceNodes.add(serviceNode);
    }

    @Override
    public void addFlowEdge(FlowEdge flowEdge) {
        this.flowEdges.add(flowEdge);
    }

    @Override
    public void populateBlackListedEdges(DirectedWeightedMultigraph<ServiceNode, FlowEdge> graph) {
        for (ServiceNode node : this.serviceNodes) {
            if (graph.containsVertex((Object)node)) {
                this.blacklistedEdges.addAll(graph.incomingEdgesOf((Object)node));
                this.blacklistedEdges.addAll(graph.outgoingEdgesOf((Object)node));
                continue;
            }
            log.info("The graph " + graph + " doesn't contains node " + node.toString());
        }
        for (FlowEdge flowEdge : this.flowEdges) {
            if (graph.containsEdge((Object)flowEdge)) {
                this.blacklistedEdges.add(flowEdge);
                continue;
            }
            log.info("The graph " + graph + "doesn't contains edge " + flowEdge.toString());
        }
    }

    @Override
    public Set<FlowEdge> getBlacklistedEdges() {
        return this.blacklistedEdges;
    }
}

