/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.flow;

import com.typesafe.config.Config;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.api.FlowEdge;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.service.modules.flow.FlowEdgeProps;
import org.jgrapht.graph.DefaultWeightedEdge;

@Alpha
public class LoadBasedFlowEdgeImpl
extends DefaultWeightedEdge
implements FlowEdge {
    private static final long serialVersionUID = 1L;
    private transient ServiceNode sourceNode;
    private transient ServiceNode targetNode;
    private transient SpecExecutor specExecutorInstance;
    private final transient FlowEdgeProps flowEdgeProps;

    public LoadBasedFlowEdgeImpl(ServiceNode sourceNode, ServiceNode targetNode, FlowEdgeProps flowEdgeProps, SpecExecutor specExecutorInstance) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.flowEdgeProps = flowEdgeProps;
        this.specExecutorInstance = specExecutorInstance;
    }

    public LoadBasedFlowEdgeImpl(ServiceNode sourceNode, ServiceNode targetNode, SpecExecutor specExecutor) {
        this(sourceNode, targetNode, new FlowEdgeProps(specExecutor.getAttrs()), specExecutor);
    }

    public double getEdgeLoad() {
        return this.getWeight();
    }

    public boolean getIsEdgeSecure() {
        return this.flowEdgeProps.isEdgeSecure();
    }

    public void setIsEdgeSecure(boolean isEdgeSecure) {
        this.flowEdgeProps.setEdgeSecure(isEdgeSecure);
    }

    public String getEdgeIdentity() {
        return LoadBasedFlowEdgeImpl.calculateEdgeIdentity(this.sourceNode, this.targetNode, this.specExecutorInstance);
    }

    public Config getEdgeProperties() {
        return this.flowEdgeProps.getConfig();
    }

    public boolean isEdgeEnabled() {
        return this.flowEdgeProps.isEdgeSecure();
    }

    public static String calculateEdgeIdentity(ServiceNode sourceNode, ServiceNode targetNode, SpecExecutor specExecutorInstance) {
        return sourceNode.getNodeName() + "-" + specExecutorInstance.getUri() + "-" + targetNode.getNodeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LoadBasedFlowEdgeImpl that = (LoadBasedFlowEdgeImpl)((Object)o);
        if (!this.sourceNode.equals(that.sourceNode)) {
            return false;
        }
        if (!this.targetNode.equals(that.targetNode)) {
            return false;
        }
        return this.specExecutorInstance.equals(that.specExecutorInstance);
    }

    public int hashCode() {
        int result = this.sourceNode.hashCode();
        result = 31 * result + this.targetNode.hashCode();
        result = 31 * result + this.specExecutorInstance.hashCode();
        return result;
    }

    public ServiceNode getSourceNode() {
        return this.sourceNode;
    }

    public ServiceNode getTargetNode() {
        return this.targetNode;
    }

    public SpecExecutor getSpecExecutorInstance() {
        return this.specExecutorInstance;
    }
}

