/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.IdealState;
import org.apache.log4j.Logger;

public class RebalanceScheduler {
    private static final Logger LOG = Logger.getLogger(RebalanceScheduler.class);
    private final Map<String, ScheduledTask> _rebalanceTasks = new HashMap<String, ScheduledTask>();
    private final ScheduledExecutorService _rebalanceExecutor = Executors.newSingleThreadScheduledExecutor();

    public void scheduleRebalance(HelixManager manager, String resource, long startTime) {
        ScheduledTask existTask = this._rebalanceTasks.get(resource);
        if (existTask != null && existTask.getStartTime() == startTime) {
            LOG.debug((Object)("Schedule timer for job: " + resource + " is up to date."));
            return;
        }
        long delay = startTime - System.currentTimeMillis();
        LOG.info((Object)("Schedule rebalance for resource : " + resource + " at time: " + startTime + " delay: " + delay));
        RebalanceInvoker rebalanceInvoker = new RebalanceInvoker(manager, resource);
        ScheduledFuture<?> future = this._rebalanceExecutor.schedule(rebalanceInvoker, delay, TimeUnit.MILLISECONDS);
        ScheduledTask prevTask = this._rebalanceTasks.put(resource, new ScheduledTask(startTime, future));
        if (prevTask != null && !prevTask.getFuture().isDone()) {
            if (!prevTask.getFuture().cancel(false)) {
                LOG.warn((Object)("Failed to cancel scheduled timer task for " + resource));
            }
            LOG.info((Object)("Remove previously scheduled timer task for " + resource));
        }
    }

    public long getRebalanceTime(String resource) {
        ScheduledTask task = this._rebalanceTasks.get(resource);
        if (task != null && !task.getFuture().isDone()) {
            return task.getStartTime();
        }
        return -1L;
    }

    public long removeScheduledRebalance(String resource) {
        ScheduledTask existTask = this._rebalanceTasks.remove(resource);
        if (existTask != null && !existTask.getFuture().isDone()) {
            if (!existTask.getFuture().cancel(true)) {
                LOG.warn((Object)("Failed to cancel scheduled timer task for " + resource));
            }
            LOG.info((Object)("Remove scheduled rebalance task at time " + existTask.getStartTime() + " for resource: " + resource));
            return existTask.getStartTime();
        }
        return -1L;
    }

    public static void invokeRebalance(HelixDataAccessor accessor, String resource) {
        LOG.info((Object)("invoke rebalance for " + resource));
        PropertyKey key = accessor.keyBuilder().idealStates(resource);
        IdealState is = (IdealState)accessor.getProperty(key);
        if (is != null) {
            if (!accessor.updateProperty(key, is)) {
                LOG.warn((Object)("Failed to invoke rebalance on resource " + resource));
            }
        } else {
            LOG.warn((Object)("Can't find ideal state for " + resource));
        }
    }

    private class RebalanceInvoker
    implements Runnable {
        private final HelixManager _manager;
        private final String _resource;

        public RebalanceInvoker(HelixManager manager, String resource) {
            this._manager = manager;
            this._resource = resource;
        }

        @Override
        public void run() {
            RebalanceScheduler.invokeRebalance(this._manager.getHelixDataAccessor(), this._resource);
        }
    }

    private class ScheduledTask {
        long _startTime;
        Future _future;

        public ScheduledTask(long _startTime, Future _future) {
            this._startTime = _startTime;
            this._future = _future;
        }

        public long getStartTime() {
            return this._startTime;
        }

        public Future getFuture() {
            return this._future;
        }
    }
}

