/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class RebalanceConfig {
    private static final int DEFAULT_REBALANCE_DELAY = -1;
    private long _rebalanceDelay = -1L;
    private RebalanceMode _rebalanceMode;
    private String _rebalancerClassName;
    private String _rebalanceStrategy;
    private Boolean _delayRebalanceDisabled;
    private long _rebalanceTimerPeriod = -1L;
    private static final Logger _logger = Logger.getLogger((String)RebalanceConfig.class.getName());

    public RebalanceConfig(ZNRecord znRecord) {
        this._rebalanceDelay = znRecord.getLongField(RebalanceConfigProperty.REBALANCE_DELAY.name(), -1L);
        this._rebalanceMode = znRecord.getEnumField(RebalanceConfigProperty.REBALANCE_MODE.name(), RebalanceMode.class, RebalanceMode.NONE);
        this._rebalancerClassName = znRecord.getSimpleField(RebalanceConfigProperty.REBALANCER_CLASS_NAME.name());
        this._rebalanceStrategy = znRecord.getSimpleField(RebalanceConfigProperty.REBALANCE_STRATEGY.name());
        this._delayRebalanceDisabled = znRecord.getBooleanField(RebalanceConfigProperty.DELAY_REBALANCE_DISABLED.name(), false);
        this._rebalanceTimerPeriod = znRecord.getLongField(RebalanceConfigProperty.REBALANCE_TIMER_PERIOD.name(), -1L);
    }

    public long getRebalanceDelay() {
        return this._rebalanceDelay;
    }

    public void setRebalanceDelay(long rebalanceDelay) {
        this._rebalanceDelay = rebalanceDelay;
    }

    public RebalanceMode getRebalanceMode() {
        return this._rebalanceMode;
    }

    public void setRebalanceMode(RebalanceMode rebalanceMode) {
        this._rebalanceMode = rebalanceMode;
    }

    public String getRebalanceClassName() {
        return this._rebalancerClassName;
    }

    public void setRebalanceClassName(String rebalancerClassName) {
        this._rebalancerClassName = rebalancerClassName;
    }

    public String getRebalanceStrategy() {
        return this._rebalanceStrategy;
    }

    public void setRebalanceStrategy(String rebalanceStrategy) {
        this._rebalanceStrategy = rebalanceStrategy;
    }

    public Boolean isDelayRebalanceDisabled() {
        return this._delayRebalanceDisabled;
    }

    public void setDelayRebalanceDisabled(Boolean delayRebalanceDisabled) {
        this._delayRebalanceDisabled = delayRebalanceDisabled;
    }

    public long getRebalanceTimerPeriod() {
        return this._rebalanceTimerPeriod;
    }

    public void setRebalanceTimerPeriod(long rebalanceTimerPeriod) {
        this._rebalanceTimerPeriod = rebalanceTimerPeriod;
    }

    public Map<String, String> getConfigsMap() {
        HashMap<String, String> simpleFieldMap = new HashMap<String, String>();
        if (this._rebalanceDelay >= 0L) {
            simpleFieldMap.put(RebalanceConfigProperty.REBALANCE_DELAY.name(), String.valueOf(this._rebalanceDelay));
        }
        if (this._rebalanceMode != null) {
            simpleFieldMap.put(RebalanceConfigProperty.REBALANCE_MODE.name(), this._rebalanceMode.name());
        }
        if (this._rebalancerClassName != null) {
            simpleFieldMap.put(RebalanceConfigProperty.REBALANCER_CLASS_NAME.name(), this._rebalancerClassName);
        }
        if (this._rebalanceStrategy != null) {
            simpleFieldMap.put(RebalanceConfigProperty.REBALANCE_STRATEGY.name(), this._rebalanceStrategy);
        }
        if (this._delayRebalanceDisabled != null) {
            simpleFieldMap.put(RebalanceConfigProperty.DELAY_REBALANCE_DISABLED.name(), String.valueOf(this._delayRebalanceDisabled));
        }
        if (this._rebalanceTimerPeriod > 0L) {
            simpleFieldMap.put(RebalanceConfigProperty.REBALANCE_TIMER_PERIOD.name(), String.valueOf(this._rebalanceTimerPeriod));
        }
        return simpleFieldMap;
    }

    public boolean isValid() {
        return true;
    }

    public static enum RebalanceMode {
        FULL_AUTO,
        SEMI_AUTO,
        CUSTOMIZED,
        USER_DEFINED,
        TASK,
        NONE;

    }

    public static enum RebalanceConfigProperty {
        REBALANCE_DELAY,
        DELAY_REBALANCE_DISABLED,
        REBALANCE_MODE,
        REBALANCER_CLASS_NAME,
        REBALANCE_TIMER_PERIOD,
        REBALANCE_STRATEGY;

    }
}

