/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.ZNRecordDelta;
import org.apache.helix.manager.zk.serializer.JacksonPayloadSerializer;
import org.apache.helix.manager.zk.serializer.PayloadSerializer;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ZNRecord {
    static Logger _logger = Logger.getLogger(ZNRecord.class);
    private final String id;
    @JsonIgnore(value=true)
    public static final String LIST_FIELD_BOUND = "listField.bound";
    @JsonIgnore(value=true)
    public static final int SIZE_LIMIT = 1024000;
    private List<ZNRecordDelta> _deltaList = new ArrayList<ZNRecordDelta>();
    private Map<String, String> simpleFields;
    private Map<String, Map<String, String>> mapFields;
    private Map<String, List<String>> listFields;
    private byte[] rawPayload;
    private PayloadSerializer _serializer;
    private int _version;
    private long _creationTime;
    private long _modifiedTime;

    @JsonCreator
    public ZNRecord(@JsonProperty(value="id") String id) {
        this.id = id;
        this.simpleFields = new TreeMap<String, String>();
        this.mapFields = new TreeMap<String, Map<String, String>>();
        this.listFields = new TreeMap<String, List<String>>();
        this.rawPayload = null;
        this._serializer = new JacksonPayloadSerializer();
    }

    public ZNRecord(ZNRecord record) {
        this(record, record.getId());
    }

    public ZNRecord(ZNRecord record, String id) {
        this(id);
        this.simpleFields.putAll(record.getSimpleFields());
        this.mapFields.putAll(record.getMapFields());
        this.listFields.putAll(record.getListFields());
        if (record.rawPayload != null) {
            this.rawPayload = new byte[record.rawPayload.length];
            System.arraycopy(record.rawPayload, 0, this.rawPayload, 0, record.rawPayload.length);
        } else {
            this.rawPayload = null;
        }
        this._version = record.getVersion();
        this._creationTime = record.getCreationTime();
        this._modifiedTime = record.getModifiedTime();
    }

    @JsonIgnore(value=true)
    public void setPayloadSerializer(PayloadSerializer serializer) {
        this._serializer = serializer;
    }

    @JsonIgnore(value=true)
    public void setDeltaList(List<ZNRecordDelta> deltaList) {
        this._deltaList = deltaList;
    }

    @JsonIgnore(value=true)
    public List<ZNRecordDelta> getDeltaList() {
        return this._deltaList;
    }

    @JsonProperty
    public Map<String, String> getSimpleFields() {
        return this.simpleFields;
    }

    @JsonProperty
    public void setSimpleFields(Map<String, String> simpleFields) {
        this.simpleFields = simpleFields;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getMapFields() {
        return this.mapFields;
    }

    @JsonProperty
    public void setMapFields(Map<String, Map<String, String>> mapFields) {
        this.mapFields = mapFields;
    }

    @JsonProperty
    public Map<String, List<String>> getListFields() {
        return this.listFields;
    }

    @JsonProperty
    public void setListFields(Map<String, List<String>> listFields) {
        this.listFields = listFields;
    }

    @JsonProperty
    public void setSimpleField(String k, String v) {
        this.simpleFields.put(k, v);
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public void setRawPayload(byte[] payload) {
        this.rawPayload = payload;
    }

    @JsonProperty
    public byte[] getRawPayload() {
        return this.rawPayload;
    }

    @JsonIgnore(value=true)
    public <T> void setPayload(T payload) {
        this.rawPayload = (byte[])(this._serializer != null && payload != null ? this._serializer.serialize(payload) : null);
    }

    @JsonIgnore(value=true)
    public <T> T getPayload(Class<T> clazz) {
        if (this._serializer != null && this.rawPayload != null) {
            return this._serializer.deserialize(clazz, this.rawPayload);
        }
        return null;
    }

    public void setMapField(String k, Map<String, String> v) {
        this.mapFields.put(k, v);
    }

    public void setListField(String k, List<String> v) {
        this.listFields.put(k, v);
    }

    public String getSimpleField(String k) {
        return this.simpleFields.get(k);
    }

    public Map<String, String> getMapField(String k) {
        return this.mapFields.get(k);
    }

    public List<String> getListField(String k) {
        return this.listFields.get(k);
    }

    public void setIntField(String k, int v) {
        this.setSimpleField(k, Integer.toString(v));
    }

    public int getIntField(String k, int defaultValue) {
        int v = defaultValue;
        String valueStr = this.getSimpleField(k);
        if (valueStr != null) {
            try {
                v = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)"", (Throwable)e);
            }
        }
        return v;
    }

    public void setLongField(String k, long v) {
        this.setSimpleField(k, Long.toString(v));
    }

    public long getLongField(String k, long defaultValue) {
        long v = defaultValue;
        String valueStr = this.getSimpleField(k);
        if (valueStr != null) {
            try {
                v = Long.parseLong(valueStr);
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)"", (Throwable)e);
            }
        }
        return v;
    }

    public void setDoubleField(String k, double v) {
        this.setSimpleField(k, Double.toString(v));
    }

    public double getDoubleField(String k, double defaultValue) {
        double v = defaultValue;
        String valueStr = this.getSimpleField(k);
        if (valueStr != null) {
            try {
                v = Double.parseDouble(valueStr);
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)"", (Throwable)e);
            }
        }
        return v;
    }

    public void setBooleanField(String k, boolean v) {
        this.setSimpleField(k, Boolean.toString(v));
    }

    public boolean getBooleanField(String k, boolean defaultValue) {
        boolean v = defaultValue;
        String valueStr = this.getSimpleField(k);
        if (valueStr != null) {
            if (valueStr.equalsIgnoreCase(Boolean.TRUE.toString())) {
                v = true;
            } else if (valueStr.equalsIgnoreCase(Boolean.FALSE.toString())) {
                v = false;
            }
        }
        return v;
    }

    public <T extends Enum<T>> void setEnumField(String k, T v) {
        this.setSimpleField(k, v.toString());
    }

    public <T extends Enum<T>> T getEnumField(String k, Class<T> enumType, T defaultValue) {
        T v = defaultValue;
        String valueStr = this.getSimpleField(k);
        if (valueStr != null) {
            try {
                v = Enum.valueOf(enumType, valueStr);
            }
            catch (NullPointerException e) {
                _logger.warn((Object)"", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                _logger.warn((Object)"", (Throwable)e);
            }
        }
        return v;
    }

    public String getStringField(String k, String defaultValue) {
        String v = defaultValue;
        String valueStr = this.getSimpleField(k);
        if (valueStr != null) {
            v = valueStr;
        }
        return v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.id + ", ");
        if (this.simpleFields != null) {
            sb.append(this.simpleFields);
        }
        if (this.mapFields != null) {
            sb.append(this.mapFields);
        }
        if (this.listFields != null) {
            sb.append(this.listFields);
        }
        return sb.toString();
    }

    public void merge(ZNRecord record) {
        if (record == null) {
            return;
        }
        if (record.getDeltaList().size() > 0) {
            _logger.info((Object)("Merging with delta list, recordId = " + this.id + " other:" + record.getId()));
            this.merge(record.getDeltaList());
            return;
        }
        this.simpleFields.putAll(record.simpleFields);
        for (String key : record.mapFields.keySet()) {
            Map<String, String> map = this.mapFields.get(key);
            if (map != null) {
                map.putAll(record.mapFields.get(key));
                continue;
            }
            this.mapFields.put(key, record.mapFields.get(key));
        }
        for (String key : record.listFields.keySet()) {
            List<String> list = this.listFields.get(key);
            if (list != null) {
                list.addAll((Collection<String>)record.listFields.get(key));
                continue;
            }
            this.listFields.put(key, record.listFields.get(key));
        }
    }

    public void update(ZNRecord record) {
        if (record != null) {
            this.simpleFields.putAll(record.simpleFields);
            this.listFields.putAll(record.listFields);
            this.mapFields.putAll(record.mapFields);
        }
    }

    void merge(ZNRecordDelta delta) {
        if (delta.getMergeOperation() == ZNRecordDelta.MergeOperation.ADD) {
            this.merge(delta.getRecord());
        } else if (delta.getMergeOperation() == ZNRecordDelta.MergeOperation.SUBTRACT) {
            this.subtract(delta.getRecord());
        } else if (delta.getMergeOperation() == ZNRecordDelta.MergeOperation.UPDATE) {
            this.update(delta.getRecord());
        }
    }

    void merge(List<ZNRecordDelta> deltaList) {
        for (ZNRecordDelta delta : deltaList) {
            this.merge(delta);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZNRecord)) {
            return false;
        }
        ZNRecord that = (ZNRecord)obj;
        if (this.getSimpleFields().size() != that.getSimpleFields().size()) {
            return false;
        }
        if (this.getMapFields().size() != that.getMapFields().size()) {
            return false;
        }
        if (this.getListFields().size() != that.getListFields().size()) {
            return false;
        }
        if (!this.getSimpleFields().equals(that.getSimpleFields())) {
            return false;
        }
        if (!this.getMapFields().equals(that.getMapFields())) {
            return false;
        }
        return this.getListFields().equals(that.getListFields());
    }

    public void subtract(ZNRecord value) {
        for (String key : value.getSimpleFields().keySet()) {
            this.simpleFields.remove(key);
        }
        for (String key : value.getListFields().keySet()) {
            this.listFields.remove(key);
        }
        for (String key : value.getMapFields().keySet()) {
            Map<String, String> map = value.getMapField(key);
            if (map == null) {
                this.mapFields.remove(key);
                continue;
            }
            Map<String, String> nestedMap = this.mapFields.get(key);
            if (nestedMap == null) continue;
            for (String mapKey : map.keySet()) {
                nestedMap.remove(mapKey);
            }
            if (nestedMap.size() != 0) continue;
            this.mapFields.remove(key);
        }
    }

    @JsonIgnore(value=true)
    public int getVersion() {
        return this._version;
    }

    @JsonIgnore(value=true)
    public void setVersion(int version) {
        this._version = version;
    }

    @JsonIgnore(value=true)
    public long getCreationTime() {
        return this._creationTime;
    }

    @JsonIgnore(value=true)
    public void setCreationTime(long creationTime) {
        this._creationTime = creationTime;
    }

    @JsonIgnore(value=true)
    public long getModifiedTime() {
        return this._modifiedTime;
    }

    @JsonIgnore(value=true)
    public void setModifiedTime(long modifiedTime) {
        this._modifiedTime = modifiedTime;
    }
}

