/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.hdfs;

import com.google.common.base.Charsets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.gobblin.config.store.deploy.FsDeploymentConfig;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class SimpleHDFSStoreMetadata {
    private static final String CONFIG_STORE_METADATA_FILENAME = "store-metadata.conf";
    private static final String CONFIG_STORE_METADATA_CURRENT_VERSION_KEY = "config.hdfs.store.version.current";
    private final FileSystem fs;
    private final Path storeMetadataFilePath;

    SimpleHDFSStoreMetadata(FileSystem fs, Path configStoreDir) {
        this.storeMetadataFilePath = new Path(configStoreDir, CONFIG_STORE_METADATA_FILENAME);
        this.fs = fs;
    }

    void writeMetadata(Config config) throws IOException {
        Path storeMetadataFileBkpPath = new Path(this.storeMetadataFilePath.getParent(), this.storeMetadataFilePath.getName() + ".bkp");
        HadoopUtils.deleteIfExists((FileSystem)this.fs, (Path)storeMetadataFileBkpPath, (boolean)true);
        if (this.fs.exists(this.storeMetadataFilePath)) {
            HadoopUtils.renamePath((FileSystem)this.fs, (Path)this.storeMetadataFilePath, (Path)storeMetadataFileBkpPath);
        }
        try (FSDataOutputStream outputStream = FileSystem.create((FileSystem)this.fs, (Path)this.storeMetadataFilePath, (FsPermission)FsDeploymentConfig.DEFAULT_STORE_PERMISSIONS);){
            outputStream.write(config.root().render(ConfigRenderOptions.concise()).getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            HadoopUtils.deleteIfExists((FileSystem)this.fs, (Path)this.storeMetadataFilePath, (boolean)true);
            HadoopUtils.renamePath((FileSystem)this.fs, (Path)storeMetadataFileBkpPath, (Path)this.storeMetadataFilePath);
            throw new IOException(String.format("Failed to write store metadata at %s. Restored existing store metadata file from backup", this.storeMetadataFilePath), e);
        }
    }

    private void addMetadata(String key, String value) throws IOException {
        Config newConfig = this.isStoreMetadataFilePresent() ? this.readMetadata().withValue(key, ConfigValueFactory.fromAnyRef((Object)value)) : ConfigFactory.empty().withValue(key, ConfigValueFactory.fromAnyRef((Object)value));
        this.writeMetadata(newConfig);
    }

    void setCurrentVersion(String version) throws IOException {
        this.addMetadata(CONFIG_STORE_METADATA_CURRENT_VERSION_KEY, version);
    }

    String getCurrentVersion() throws IOException {
        return this.readMetadata().getString(CONFIG_STORE_METADATA_CURRENT_VERSION_KEY);
    }

    Config readMetadata() throws IOException {
        if (!this.isStoreMetadataFilePresent()) {
            throw new IOException("Store metadata file does not exist at " + this.storeMetadataFilePath);
        }
        try (FSDataInputStream storeMetadataInputStream = this.fs.open(this.storeMetadataFilePath);){
            Config config = ConfigFactory.parseReader((Reader)new InputStreamReader((InputStream)storeMetadataInputStream, Charsets.UTF_8));
            return config;
        }
    }

    private boolean isStoreMetadataFilePresent() throws IOException {
        return this.fs.exists(this.storeMetadataFilePath);
    }
}

