/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.common.impl;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.gobblin.config.common.impl.CircularDependencyException;

class ImportTraverser<T> {
    private final Function<T, List<T>> traversalFunction;
    private final Cache<T, LinkedList<T>> traversalCache;

    List<T> traverseGraphRecursively(T startingNode) {
        return this.doTraverseGraphRecursively(startingNode, new NodePath<T>(startingNode));
    }

    private List<T> doTraverseGraphRecursively(T node, NodePath<T> nodePath) {
        try {
            return (List)this.traversalCache.get(node, () -> this.computeRecursiveTraversal(node, nodePath));
        }
        catch (UncheckedExecutionException | ExecutionException ee) {
            throw this.unpackExecutionException(ee);
        }
    }

    private LinkedList<T> computeRecursiveTraversal(T node, NodePath<T> nodePath) {
        try {
            LinkedList imports = new LinkedList();
            HashSet alreadyIncludedImports = new HashSet();
            for (T neighbor : this.traversalFunction.apply(node)) {
                nodePath.appendNode(neighbor);
                this.addSubtraversal(neighbor, imports, alreadyIncludedImports, nodePath);
                nodePath.popTail();
            }
            return imports;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    private void addSubtraversal(T node, LinkedList<T> imports, Set<T> alreadyIncludedImports, NodePath<T> nodePath) throws ExecutionException {
        if (this.addNodeIfNotAlreadyIncluded(node, imports, alreadyIncludedImports)) {
            for (T inheritedFromParent : this.doTraverseGraphRecursively(node, nodePath)) {
                this.addNodeIfNotAlreadyIncluded(inheritedFromParent, imports, alreadyIncludedImports);
            }
        }
    }

    private boolean addNodeIfNotAlreadyIncluded(T thisImport, LinkedList<T> imports, Set<T> alreadyIncludedImports) {
        if (alreadyIncludedImports.contains(thisImport)) {
            return false;
        }
        imports.add(thisImport);
        alreadyIncludedImports.add(thisImport);
        return true;
    }

    private RuntimeException unpackExecutionException(Throwable exc) {
        while (exc instanceof ExecutionException || exc instanceof UncheckedExecutionException) {
            exc = exc.getCause();
        }
        return Throwables.propagate((Throwable)exc);
    }

    @ConstructorProperties(value={"traversalFunction", "traversalCache"})
    public ImportTraverser(Function<T, List<T>> traversalFunction, Cache<T, LinkedList<T>> traversalCache) {
        this.traversalFunction = traversalFunction;
        this.traversalCache = traversalCache;
    }

    private static class NodePath<T> {
        private final Set<T> nodesSet = new HashSet<T>();
        private final LinkedList<T> nodesList = new LinkedList();

        public NodePath(T initialNode) {
            this.nodesSet.add(initialNode);
            this.nodesList.add(initialNode);
        }

        public void appendNode(T node) {
            if (this.nodesSet.contains(node)) {
                throw new CircularDependencyException("Found cycle in traversal: " + this.computePath(node));
            }
            this.nodesSet.add(node);
            this.nodesList.add(node);
        }

        public void popTail() {
            T removed = this.nodesList.removeLast();
            this.nodesSet.remove(removed);
        }

        private String computePath(T node) {
            StringBuilder sb = new StringBuilder();
            for (Object t : this.nodesList.subList(this.nodesList.indexOf(node), this.nodesList.size())) {
                sb.append(t).append(" -> ");
            }
            sb.append(node);
            return sb.toString();
        }
    }
}

