/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class TimestampedDatasetVersion
implements FileSystemDatasetVersion {
    protected final DateTime version;
    protected final Path path;

    public TimestampedDatasetVersion(DateTime version, Path path) {
        this.version = version;
        this.path = path;
    }

    public DateTime getDateTime() {
        return this.version;
    }

    @Override
    public int compareTo(FileSystemDatasetVersion other) {
        TimestampedDatasetVersion otherAsDateTime = (TimestampedDatasetVersion)other;
        return this.version.equals((Object)otherAsDateTime.version) ? this.path.compareTo((Object)otherAsDateTime.path) : this.version.compareTo((ReadableInstant)otherAsDateTime.version);
    }

    public boolean equals(Object obj) {
        return obj instanceof TimestampedDatasetVersion && this.compareTo((TimestampedDatasetVersion)obj) == 0;
    }

    public int hashCode() {
        return this.version.hashCode() + this.path.hashCode();
    }

    public String toString() {
        return "Version " + this.version.toString(DateTimeFormat.shortDateTime()) + " at path " + this.path;
    }

    @Override
    public Set<Path> getPaths() {
        return Sets.newHashSet((Object[])new Path[]{this.path});
    }

    public DateTime getVersion() {
        return this.version;
    }

    public Path getPath() {
        return this.path;
    }
}

