/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringMap;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.EmptyRecord;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.server.CreateResponse;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.UpdateResponse;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.resources.ComplexKeyResourceTemplate;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.spec_catalog.FlowCatalog;
import org.apache.gobblin.service.FlowConfig;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.Schedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RestLiCollection(name="flowconfigs", namespace="org.apache.gobblin.service", keyName="id")
public class FlowConfigsResource
extends ComplexKeyResourceTemplate<FlowId, EmptyRecord, FlowConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowConfigsResource.class);
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static FlowCatalog _globalFlowCatalog;
    @Inject
    @Named(value="flowCatalog")
    private FlowCatalog _flowCatalog;
    @Inject
    @Named(value="readyToUse")
    private Boolean readyToUse = Boolean.FALSE;

    public void logAndThrowRestLiServiceException(HttpStatus status, String msg, Exception e) {
        if (e != null) {
            LOG.error(msg, (Throwable)e);
            throw new RestLiServiceException(status, msg + " cause = " + e.getMessage());
        }
        LOG.error(msg);
        throw new RestLiServiceException(status, msg);
    }

    public FlowConfig get(ComplexResourceKey<FlowId, EmptyRecord> key) {
        String flowGroup = ((FlowId)key.getKey()).getFlowGroup();
        String flowName = ((FlowId)key.getKey()).getFlowName();
        LOG.info("Get called with flowGroup " + flowGroup + " flowName " + flowName);
        try {
            URI flowCatalogURI = new URI("gobblin-flow", null, "/", null, null);
            URI flowUri = new URI(flowCatalogURI.getScheme(), flowCatalogURI.getAuthority(), "/" + flowGroup + "/" + flowName, null, null);
            FlowSpec spec = (FlowSpec)this.getFlowCatalog().getSpec(flowUri);
            FlowConfig flowConfig = new FlowConfig();
            Properties flowProps = spec.getConfigAsProperties();
            Schedule schedule = null;
            if (flowProps.containsKey("job.schedule")) {
                schedule = new Schedule();
                schedule.setCronSchedule(flowProps.getProperty("job.schedule"));
            }
            if (flowProps.containsKey("job.template")) {
                flowConfig.setTemplateUris(flowProps.getProperty("job.template"));
            } else if (spec.getTemplateURIs().isPresent()) {
                flowConfig.setTemplateUris(StringUtils.join((Collection)((Collection)spec.getTemplateURIs().get()), (String)","));
            } else {
                flowConfig.setTemplateUris("NA");
            }
            if (schedule != null) {
                if (flowProps.containsKey("flow.runImmediately")) {
                    schedule.setRunImmediately(Boolean.valueOf(flowProps.getProperty("flow.runImmediately")));
                }
                flowConfig.setSchedule(schedule);
            }
            flowProps.remove("job.schedule");
            flowProps.remove("job.template");
            StringMap flowPropsAsStringMap = new StringMap();
            flowPropsAsStringMap.putAll((Map)Maps.fromProperties((Properties)flowProps));
            return flowConfig.setId(new FlowId().setFlowGroup(flowGroup).setFlowName(flowName)).setProperties(flowPropsAsStringMap);
        }
        catch (URISyntaxException e) {
            this.logAndThrowRestLiServiceException(HttpStatus.S_400_BAD_REQUEST, "bad URI " + flowName, e);
        }
        catch (SpecNotFoundException e) {
            this.logAndThrowRestLiServiceException(HttpStatus.S_404_NOT_FOUND, "Flow requested does not exist: " + flowName, null);
        }
        return null;
    }

    private FlowSpec createFlowSpecForConfig(FlowConfig flowConfig) {
        ConfigBuilder configBuilder = ConfigBuilder.create().addPrimitive("flow.group", (Object)flowConfig.getId().getFlowGroup()).addPrimitive("flow.name", (Object)flowConfig.getId().getFlowName());
        if (flowConfig.hasSchedule()) {
            Schedule schedule = flowConfig.getSchedule();
            configBuilder.addPrimitive("job.schedule", (Object)schedule.getCronSchedule());
            configBuilder.addPrimitive("flow.runImmediately", (Object)schedule.isRunImmediately());
        }
        Config config = configBuilder.build();
        Config configWithFallback = config.withFallback((ConfigMergeable)ConfigFactory.parseMap((Map)flowConfig.getProperties()));
        URI templateURI = null;
        try {
            templateURI = new URI(flowConfig.getTemplateUris());
        }
        catch (URISyntaxException e) {
            this.logAndThrowRestLiServiceException(HttpStatus.S_400_BAD_REQUEST, "bad URI " + flowConfig.getTemplateUris(), e);
        }
        return FlowSpec.builder().withConfig(configWithFallback).withTemplate(templateURI).build();
    }

    public CreateResponse create(FlowConfig flowConfig) {
        LOG.info("Create called with flowName " + flowConfig.getId().getFlowName());
        LOG.debug("ReadyToUse is: " + this.readyToUse);
        LOG.debug("FlowCatalog is: " + this.getFlowCatalog());
        if (!this.readyToUse.booleanValue() && this.getFlowCatalog() == null) {
            throw new RuntimeException("Not ready for use.");
        }
        this.getFlowCatalog().put((Spec)this.createFlowSpecForConfig(flowConfig));
        return new CreateResponse((Object)new ComplexResourceKey((RecordTemplate)flowConfig.getId(), (RecordTemplate)new EmptyRecord()), HttpStatus.S_201_CREATED);
    }

    public UpdateResponse update(ComplexResourceKey<FlowId, EmptyRecord> key, FlowConfig flowConfig) {
        String flowGroup = ((FlowId)key.getKey()).getFlowGroup();
        String flowName = ((FlowId)key.getKey()).getFlowName();
        LOG.info("Update called with flowGroup " + flowGroup + " flowName " + flowName);
        if (!flowGroup.equals(flowConfig.getId().getFlowGroup()) || !flowName.equals(flowConfig.getId().getFlowName())) {
            this.logAndThrowRestLiServiceException(HttpStatus.S_400_BAD_REQUEST, "flowName and flowGroup cannot be changed in update", null);
        }
        this.getFlowCatalog().put((Spec)this.createFlowSpecForConfig(flowConfig));
        return new UpdateResponse(HttpStatus.S_200_OK);
    }

    public UpdateResponse delete(ComplexResourceKey<FlowId, EmptyRecord> key) {
        String flowGroup = ((FlowId)key.getKey()).getFlowGroup();
        String flowName = ((FlowId)key.getKey()).getFlowName();
        URI flowUri = null;
        LOG.info("Delete called with flowGroup " + flowGroup + " flowName " + flowName);
        try {
            URI flowCatalogURI = new URI("gobblin-flow", null, "/", null, null);
            flowUri = new URI(flowCatalogURI.getScheme(), flowCatalogURI.getAuthority(), "/" + flowGroup + "/" + flowName, null, null);
            this.getFlowCatalog().remove(flowUri);
            return new UpdateResponse(HttpStatus.S_200_OK);
        }
        catch (URISyntaxException e) {
            this.logAndThrowRestLiServiceException(HttpStatus.S_400_BAD_REQUEST, "bad URI " + flowUri, e);
            return null;
        }
    }

    private FlowCatalog getFlowCatalog() {
        if (null != _globalFlowCatalog) {
            return _globalFlowCatalog;
        }
        return this._flowCatalog;
    }
}

