/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public interface MutableJobCatalog
extends JobCatalog {
    public void put(JobSpec var1);

    public void remove(URI var1);

    public static class MutableStandardMetrics
    extends JobCatalog.StandardMetrics {
        private static final Logger log = LoggerFactory.getLogger(MutableStandardMetrics.class);
        public static final String TIME_FOR_JOB_CATALOG_REMOVE = "timeForJobCatalogRemove";
        public static final String TIME_FOR_JOB_CATALOG_PUT = "timeForJobCatalogPut";
        private final ContextAwareTimer timeForJobCatalogPut;
        private final ContextAwareTimer timeForJobCatalogRemove;

        public MutableStandardMetrics(JobCatalog catalog, Optional<Config> sysConfig) {
            super(catalog, sysConfig);
            this.timeForJobCatalogPut = catalog.getMetricContext().contextAwareTimer(TIME_FOR_JOB_CATALOG_PUT, (long)this.timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.timeForJobCatalogRemove = catalog.getMetricContext().contextAwareTimer(TIME_FOR_JOB_CATALOG_REMOVE, (long)this.timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.contextAwareMetrics.add(this.timeForJobCatalogPut);
            this.contextAwareMetrics.add(this.timeForJobCatalogRemove);
        }

        public void updatePutJobTime(long startTime) {
            log.info("updatePutJobTime...");
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeForJobCatalogPut), (long)(System.currentTimeMillis() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        public void updateRemoveJobTime(long startTime) {
            log.info("updateRemoveJobTime...");
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeForJobCatalogRemove), (long)(System.currentTimeMillis() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        public ContextAwareTimer getTimeForJobCatalogPut() {
            return this.timeForJobCatalogPut;
        }

        public ContextAwareTimer getTimeForJobCatalogRemove() {
            return this.timeForJobCatalogRemove;
        }
    }
}

