/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.yarn;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

public class YarnHelixUtils {
    public static void writeTokenToFile(Token<? extends TokenIdentifier> token, Path tokenFilePath, Configuration configuration) throws IOException {
        Credentials credentials = new Credentials();
        credentials.addToken(token.getService(), token);
        credentials.writeTokenStorageFile(tokenFilePath, configuration);
    }

    public static Collection<Token<? extends TokenIdentifier>> readTokensFromFile(Path tokenFilePath, Configuration configuration) throws IOException {
        return Credentials.readTokenStorageFile((Path)tokenFilePath, (Configuration)configuration).getAllTokens();
    }

    public static void addFileAsLocalResource(FileSystem fs, Path destFilePath, LocalResourceType resourceType, Map<String, LocalResource> resourceMap) throws IOException {
        LocalResource fileResource = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus fileStatus = fs.getFileStatus(destFilePath);
        fileResource.setResource(ConverterUtils.getYarnUrlFromPath((Path)destFilePath));
        fileResource.setSize(fileStatus.getLen());
        fileResource.setTimestamp(fileStatus.getModificationTime());
        fileResource.setType(resourceType);
        fileResource.setVisibility(LocalResourceVisibility.APPLICATION);
        resourceMap.put(destFilePath.getName(), fileResource);
    }

    public static Map<String, String> getEnvironmentVariables(Configuration yarnConfiguration) {
        HashMap environmentVariableMap = Maps.newHashMap();
        if (System.getenv().containsKey(ApplicationConstants.Environment.JAVA_HOME.key())) {
            Apps.addToEnvironment((Map)environmentVariableMap, (String)ApplicationConstants.Environment.JAVA_HOME.key(), (String)System.getenv(ApplicationConstants.Environment.JAVA_HOME.key()));
        }
        Apps.addToEnvironment((Map)environmentVariableMap, (String)ApplicationConstants.Environment.CLASSPATH.key(), (String)ApplicationConstants.Environment.PWD.$());
        Apps.addToEnvironment((Map)environmentVariableMap, (String)ApplicationConstants.Environment.CLASSPATH.key(), (String)(ApplicationConstants.Environment.PWD.$() + File.separator + "*"));
        String[] classpaths = yarnConfiguration.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH);
        if (classpaths != null) {
            for (String classpath : classpaths) {
                Apps.addToEnvironment((Map)environmentVariableMap, (String)ApplicationConstants.Environment.CLASSPATH.key(), (String)classpath.trim());
            }
        }
        return environmentVariableMap;
    }
}

