/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.idlcheck;

import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import com.linkedin.data.schema.resolver.MultiFormatDataSchemaResolver;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.tools.compatibility.CompatibilityInfoMap;
import com.linkedin.restli.tools.compatibility.CompatibilityReport;
import com.linkedin.restli.tools.compatibility.ResourceCompatibilityChecker;
import com.linkedin.restli.tools.idlcheck.CompatibilityInfo;
import com.linkedin.restli.tools.idlcheck.CompatibilityLevel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiResourceModelCompatibilityChecker {
    private String _prevRestspecPath;
    private String _currRestspecPath;
    private String _resolverPath;
    private static final RestSpecCodec _codec = new RestSpecCodec();
    private static final Logger log = LoggerFactory.getLogger(RestLiResourceModelCompatibilityChecker.class);
    private final CompatibilityInfoMap _infoMap = new CompatibilityInfoMap();

    public static void main(String[] args) {
        CompatibilityLevel compat;
        CommandLine cmd;
        Options options = new Options();
        options.addOption("h", "help", false, "Print help");
        OptionBuilder.withArgName((String)"compatibility_level");
        OptionBuilder.withLongOpt((String)"compat");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)("Compatibility level " + RestLiResourceModelCompatibilityChecker.listCompatLevelOptions()));
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"report");
        OptionBuilder.withDescription((String)"Prints a report at the end of the execution that can be parsed for reporting to other tools");
        options.addOption(OptionBuilder.create((String)"report"));
        String cmdLineSyntax = RestLiResourceModelCompatibilityChecker.class.getCanonicalName() + " [pairs of <prevRestspecPath currRestspecPath>]";
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp(cmdLineSyntax, options, true);
            System.exit(255);
            return;
        }
        String[] targets = cmd.getArgs();
        if (cmd.hasOption('h') || targets.length < 2 || targets.length % 2 != 0) {
            new HelpFormatter().printHelp(cmdLineSyntax, options, true);
            System.exit(255);
        }
        String compatValue = cmd.hasOption('c') ? cmd.getOptionValue('c') : CompatibilityLevel.DEFAULT.name();
        try {
            compat = CompatibilityLevel.valueOf(compatValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            new HelpFormatter().printHelp(cmdLineSyntax, options, true);
            System.exit(255);
            return;
        }
        StringBuilder allSummaries = new StringBuilder();
        RestLiResourceModelCompatibilityChecker checker = new RestLiResourceModelCompatibilityChecker();
        for (int i = 1; i < targets.length; i += 2) {
            checker.setResolverPath(System.getProperty("generator.resolver.path"));
            String prevTarget = targets[i - 1];
            String currTarget = targets[i];
            checker.check(prevTarget, currTarget, compat);
        }
        allSummaries.append(checker.getInfoMap().createSummary());
        if (compat != CompatibilityLevel.OFF && allSummaries.length() > 0) {
            System.out.println(allSummaries);
        }
        if (cmd.hasOption("report")) {
            System.out.println(new CompatibilityReport(checker.getInfoMap(), compat).createReport());
            System.exit(0);
        }
        System.exit(checker.getInfoMap().isCompatible(compat) ? 0 : 1);
    }

    public void setResolverPath(String resolverPath) {
        this._resolverPath = resolverPath;
    }

    public boolean check(String prevRestspecPath, String currRestspecPath, CompatibilityLevel compatLevel) {
        this._prevRestspecPath = prevRestspecPath;
        this._currRestspecPath = currRestspecPath;
        Stack<Object> path = new Stack<Object>();
        path.push("");
        ResourceSchema prevRec = null;
        ResourceSchema currRec = null;
        try {
            prevRec = _codec.readResourceSchema((InputStream)new FileInputStream(prevRestspecPath));
        }
        catch (FileNotFoundException e) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.RESOURCE_NEW, path, currRestspecPath);
        }
        catch (IOException e) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.OTHER_ERROR, path, e.getMessage());
        }
        try {
            currRec = _codec.readResourceSchema((InputStream)new FileInputStream(currRestspecPath));
        }
        catch (FileNotFoundException e) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.RESOURCE_MISSING, path, prevRestspecPath);
        }
        catch (Exception e) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.OTHER_ERROR, path, e.getMessage());
        }
        if (prevRec == null || currRec == null) {
            return this._infoMap.isCompatible(compatLevel);
        }
        Object resolver = this._resolverPath == null ? new DefaultDataSchemaResolver() : MultiFormatDataSchemaResolver.withBuiltinFormats((String)this._resolverPath);
        ResourceCompatibilityChecker checker = new ResourceCompatibilityChecker(prevRec, (DataSchemaResolver)resolver, currRec, (DataSchemaResolver)resolver);
        boolean check = checker.check(compatLevel);
        this._infoMap.addAll(checker.getInfoMap());
        return check;
    }

    public boolean check(String prevRestspecPath, String currRestspecPath) {
        return this.check(prevRestspecPath, currRestspecPath, CompatibilityLevel.EQUIVALENT);
    }

    @Deprecated
    public Collection<CompatibilityInfo> getIncompatibles() {
        return this._infoMap.getIncompatibles();
    }

    @Deprecated
    public Collection<CompatibilityInfo> getCompatibles() {
        return this._infoMap.getCompatibles();
    }

    @Deprecated
    public String getSummary() {
        return this._infoMap.createSummary(this._prevRestspecPath, this._currRestspecPath);
    }

    private static String listCompatLevelOptions() {
        StringBuilder options = new StringBuilder("<");
        for (CompatibilityLevel compatLevel : CompatibilityLevel.values()) {
            options.append(compatLevel.name().toLowerCase()).append("|");
        }
        options.replace(options.length() - 1, options.length(), ">");
        return options.toString();
    }

    public CompatibilityInfoMap getInfoMap() {
        return this._infoMap;
    }
}

