/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.clientgen;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.StringArray;
import com.linkedin.jersey.api.uri.UriTemplate;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.internal.common.RestliVersion;
import com.linkedin.restli.internal.tools.RestLiToolsUtils;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionSchemaArray;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.FinderSchemaArray;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.ResourceSchemaArray;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestMethodSchemaArray;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.restli.tools.clientgen.builderspec.ActionBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.ActionParamBindingMethodSpec;
import com.linkedin.restli.tools.clientgen.builderspec.ActionSetRootBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.BuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.CollectionRootBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.FinderBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.PathKeyBindingMethodSpec;
import com.linkedin.restli.tools.clientgen.builderspec.QueryParamBindingMethodSpec;
import com.linkedin.restli.tools.clientgen.builderspec.RequestBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.RestMethodBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.RootBuilderMethodSpec;
import com.linkedin.restli.tools.clientgen.builderspec.RootBuilderSpec;
import com.linkedin.restli.tools.clientgen.builderspec.SimpleRootBuilderSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBuilderSpecGenerator {
    private static final Logger log = LoggerFactory.getLogger(RequestBuilderSpecGenerator.class);
    private static final Map<RestliVersion, String> ROOT_BUILDERS_SUFFIX = new HashMap<RestliVersion, String>();
    private static final Map<RestliVersion, String> METHOD_BUILDER_SUFFIX;
    private final String _customMethodBuilderSuffix;
    protected final Set<BuilderSpec> _builderSpecs = new LinkedHashSet<BuilderSpec>();
    private final DataSchemaResolver _schemaResolver;
    private final TemplateSpecGenerator _templateSpecGenerator;
    private final RestliVersion _version;
    private final Map<ResourceMethod, String> _builderBaseMap;
    private DataSchemaLocation _currentSchemaLocation;

    public RequestBuilderSpecGenerator(DataSchemaResolver schemaResolver, TemplateSpecGenerator templateSpecGenerator, RestliVersion version, Map<ResourceMethod, String> builderBaseMap) {
        this(schemaResolver, templateSpecGenerator, version, builderBaseMap, null);
    }

    public RequestBuilderSpecGenerator(DataSchemaResolver schemaResolver, TemplateSpecGenerator templateSpecGenerator, RestliVersion version, Map<ResourceMethod, String> builderBaseMap, String customMethodBuilderSuffix) {
        this._schemaResolver = schemaResolver;
        this._templateSpecGenerator = templateSpecGenerator;
        this._version = version;
        this._builderBaseMap = builderBaseMap;
        this._customMethodBuilderSuffix = customMethodBuilderSuffix;
    }

    public String getBuilderBase(ResourceMethod method) {
        if (this._builderBaseMap != null) {
            return this._builderBaseMap.get(method);
        }
        return null;
    }

    private void registerBuilderSpec(BuilderSpec builder) {
        this._builderSpecs.add(builder);
    }

    public Set<BuilderSpec> getBuilderSpec() {
        return this._builderSpecs;
    }

    private static String getBuilderClassNameByVersion(RestliVersion version, String namespace, String builderName, boolean isRootBuilders) {
        String className = (namespace == null || namespace.trim().isEmpty() ? "" : namespace + ".") + CodeUtil.capitalize((String)builderName);
        Map<RestliVersion, String> suffixMap = isRootBuilders ? ROOT_BUILDERS_SUFFIX : METHOD_BUILDER_SUFFIX;
        return className + suffixMap.get(version);
    }

    public void generate(ResourceSchema resource, File sourceFile) {
        try {
            this._currentSchemaLocation = new FileDataSchemaLocation(sourceFile);
            this.generateRootRequestBuilder(null, resource, sourceFile.getAbsolutePath(), new HashMap<String, String>());
        }
        catch (IOException e) {
            throw new RuntimeException("Error processing file [" + sourceFile.getAbsolutePath() + "] " + e.getMessage(), e);
        }
    }

    private RootBuilderSpec generateRootRequestBuilder(RootBuilderSpec parentRootBuilder, ResourceSchema resource, String sourceFile, Map<String, String> pathKeyTypes) throws IOException {
        ValidationResult validationResult = ValidateDataAgainstSchema.validate((Object)resource.data(), (DataSchema)resource.schema(), (ValidationOptions)new ValidationOptions(RequiredMode.MUST_BE_PRESENT));
        if (!validationResult.isValid()) {
            throw new IllegalArgumentException(String.format("Resource validation error.  Resource File '%s', Error Details '%s'", sourceFile, validationResult.toString()));
        }
        String packageName = resource.getNamespace();
        String resourceName = CodeUtil.capitalize((String)resource.getName());
        String className = this._version == RestliVersion.RESTLI_2_0_0 ? RequestBuilderSpecGenerator.getBuilderClassNameByVersion(RestliVersion.RESTLI_2_0_0, null, resource.getName(), true) : RequestBuilderSpecGenerator.getBuilderClassNameByVersion(RestliVersion.RESTLI_1_0_0, null, resource.getName(), true);
        RootBuilderSpec rootBuilderSpec = null;
        if (resource.hasCollection()) {
            rootBuilderSpec = new CollectionRootBuilderSpec(resource);
        } else if (resource.hasSimple()) {
            rootBuilderSpec = new SimpleRootBuilderSpec(resource);
        } else if (resource.hasActionsSet()) {
            rootBuilderSpec = new ActionSetRootBuilderSpec(resource);
        } else {
            throw new IllegalArgumentException("unsupported resource type for resource: '" + resourceName + '\'');
        }
        rootBuilderSpec.setNamespace(packageName);
        rootBuilderSpec.setClassName(className);
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            rootBuilderSpec.setBaseClassName("BuilderBase");
        }
        rootBuilderSpec.setSourceIdlName(sourceFile);
        String resourcePath = RequestBuilderSpecGenerator.getResourcePath(resource.getPath());
        rootBuilderSpec.setResourcePath(resourcePath);
        List<String> pathKeys = RequestBuilderSpecGenerator.getPathKeys(resourcePath);
        rootBuilderSpec.setPathKeys(pathKeys);
        rootBuilderSpec.setParentRootBuilder(parentRootBuilder);
        StringArray supportsList = null;
        RestMethodSchemaArray restMethods = null;
        FinderSchemaArray finders = null;
        ResourceSchemaArray subresources = null;
        ActionSchemaArray resourceActions = null;
        ActionSchemaArray entityActions = null;
        String keyClass = null;
        if (resource.getCollection() != null) {
            CollectionSchema collection = resource.getCollection();
            String keyName = collection.getIdentifier().getName();
            keyClass = collection.getIdentifier().getType();
            pathKeyTypes.put(keyName, collection.getIdentifier().getType());
            supportsList = collection.getSupports();
            restMethods = collection.getMethods();
            finders = collection.getFinders();
            subresources = collection.getEntity().getSubresources();
            resourceActions = collection.getActions();
            entityActions = collection.getEntity().getActions();
        } else if (resource.getSimple() != null) {
            SimpleSchema simpleSchema = resource.getSimple();
            keyClass = "Void";
            supportsList = simpleSchema.getSupports();
            restMethods = simpleSchema.getMethods();
            subresources = simpleSchema.getEntity().getSubresources();
            resourceActions = simpleSchema.getActions();
        } else if (resource.getActionsSet() != null) {
            ActionsSetSchema actionsSet = resource.getActionsSet();
            resourceActions = actionsSet.getActions();
        }
        Set<ResourceMethod> supportedMethods = RequestBuilderSpecGenerator.getSupportedMethods(supportsList);
        if (!supportedMethods.isEmpty()) {
            for (ResourceMethod resourceMethod : supportedMethods) {
                RequestBuilderSpecGenerator.validateResourceMethod(resource, resourceName, resourceMethod);
            }
        }
        ArrayList<RootBuilderMethodSpec> restMethodSpecs = new ArrayList();
        ArrayList<RootBuilderMethodSpec> finderSpecs = new ArrayList();
        ArrayList<RootBuilderMethodSpec> resourceActionSpecs = new ArrayList();
        ArrayList<RootBuilderMethodSpec> entityActionSpecs = new ArrayList();
        ArrayList<RootBuilderSpec> subresourceSpecs = new ArrayList();
        String schemaClass = resource.getSchema();
        if (restMethods != null) {
            restMethodSpecs = this.generateBasicMethods(rootBuilderSpec, keyClass, schemaClass, supportedMethods, restMethods, resourceName, pathKeys, pathKeyTypes);
        }
        if (finders != null) {
            finderSpecs = this.generateFinders(rootBuilderSpec, finders, keyClass, schemaClass, resourceName, pathKeys, pathKeyTypes);
        }
        if (resourceActions != null) {
            resourceActionSpecs = this.generateActions(rootBuilderSpec, resourceActions, keyClass, resourceName, pathKeys, pathKeyTypes);
        }
        if (entityActions != null) {
            entityActionSpecs = this.generateActions(rootBuilderSpec, entityActions, keyClass, resourceName, pathKeys, pathKeyTypes);
        }
        if (subresources != null) {
            subresourceSpecs = this.generateSubResources(sourceFile, rootBuilderSpec, subresources, pathKeyTypes);
        }
        if (rootBuilderSpec instanceof CollectionRootBuilderSpec) {
            CollectionRootBuilderSpec rootBuilder = (CollectionRootBuilderSpec)rootBuilderSpec;
            rootBuilder.setRestMethods(restMethodSpecs);
            rootBuilder.setFinders(finderSpecs);
            rootBuilder.setResourceActions(resourceActionSpecs);
            rootBuilder.setEntityActions(entityActionSpecs);
            rootBuilder.setSubresources(subresourceSpecs);
        } else if (rootBuilderSpec instanceof SimpleRootBuilderSpec) {
            SimpleRootBuilderSpec rootBuilder = (SimpleRootBuilderSpec)rootBuilderSpec;
            rootBuilder.setRestMethods(restMethodSpecs);
            rootBuilder.setResourceActions(resourceActionSpecs);
            rootBuilder.setSubresources(subresourceSpecs);
        } else if (rootBuilderSpec instanceof ActionSetRootBuilderSpec) {
            ActionSetRootBuilderSpec rootBuilder = (ActionSetRootBuilderSpec)rootBuilderSpec;
            rootBuilder.setResourceActions(resourceActionSpecs);
        }
        this.registerBuilderSpec(rootBuilderSpec);
        return rootBuilderSpec;
    }

    private static List<String> fixOldStylePathKeys(List<String> pathKeys, String resourcePath, Map<String, List<String>> pathToAssocKeys) {
        if (resourcePath.contains("=")) {
            ArrayList<String> newPathKeys = new ArrayList<String>(pathKeys.size());
            Map<String, String> assocToPathKeys = RequestBuilderSpecGenerator.reverseMap(pathToAssocKeys);
            HashSet<String> prevRealPathKeys = new HashSet<String>();
            for (String currKey : pathKeys) {
                if (assocToPathKeys.containsKey(currKey)) {
                    if (prevRealPathKeys.contains(assocToPathKeys.get(currKey))) continue;
                    prevRealPathKeys.add(assocToPathKeys.get(currKey));
                    newPathKeys.add(assocToPathKeys.get(currKey));
                    continue;
                }
                newPathKeys.add(currKey);
            }
            return newPathKeys;
        }
        return pathKeys;
    }

    private static Map<String, String> reverseMap(Map<String, List<String>> toReverse) {
        HashMap<String, String> reversed = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : toReverse.entrySet()) {
            for (String element : entry.getValue()) {
                reversed.put(element, entry.getKey());
            }
        }
        return reversed;
    }

    private static void validateResourceMethod(ResourceSchema resourceSchema, String resourceName, ResourceMethod resourceMethod) {
        if (resourceSchema.getSimple() != null && !RestConstants.SIMPLE_RESOURCE_METHODS.contains(resourceMethod)) {
            throw new IllegalArgumentException(String.format("'%s' is not a supported method on resource: '%s'", resourceMethod.toString(), resourceName));
        }
    }

    private static List<String> getPathKeys(String basePath) {
        UriTemplate template = new UriTemplate(basePath);
        return RequestBuilderSpecGenerator.fixOldStylePathKeys(template.getTemplateVariables(), basePath, new HashMap<String, List<String>>());
    }

    private List<RootBuilderSpec> generateSubResources(String sourceFile, RootBuilderSpec parentRootBuilder, ResourceSchemaArray subresources, Map<String, String> pathKeyTypes) throws IOException {
        ArrayList<RootBuilderSpec> subSpecList = new ArrayList<RootBuilderSpec>();
        if (subresources != null) {
            for (ResourceSchema resource : subresources) {
                RootBuilderSpec resourceSpec = this.generateRootRequestBuilder(parentRootBuilder, resource, sourceFile, pathKeyTypes);
                subSpecList.add(resourceSpec);
            }
        }
        return subSpecList;
    }

    private List<RootBuilderMethodSpec> generateFinders(RootBuilderSpec rootBuilderSpec, FinderSchemaArray finderSchemas, String keyClass, String valueClass, String resourceName, List<String> pathKeys, Map<String, String> pathKeyTypes) {
        ArrayList<RootBuilderMethodSpec> finderSpecList = new ArrayList<RootBuilderMethodSpec>();
        if (finderSchemas != null) {
            String baseBuilderClass = this.getBuilderBase(ResourceMethod.FINDER);
            for (FinderSchema finder : finderSchemas) {
                String finderName = finder.getName();
                String builderName = CodeUtil.capitalize((String)resourceName) + "FindBy" + CodeUtil.capitalize((String)finderName) + this.getMethodBuilderSuffix();
                FinderBuilderSpec finderBuilderClass = this.generateFinderRequestBuilder(rootBuilderSpec.getResource(), baseBuilderClass, keyClass, valueClass, builderName, rootBuilderSpec.getNamespace(), finderName, finder);
                this.generatePathKeyBindingMethods(pathKeys, finderBuilderClass, pathKeyTypes);
                if (finder.getParameters() != null) {
                    this.generateQueryParamBindingMethods(finder.getParameters(), finderBuilderClass);
                }
                if (finder.getMetadata() != null) {
                    String metadataClass = finder.getMetadata().getType();
                    ClassTemplateSpec metadataClassSpec = this.classToTemplateSpec(metadataClass);
                    finderBuilderClass.setMetadataType(metadataClassSpec);
                }
                String finderMethod = "findBy" + CodeUtil.capitalize((String)finderName);
                RootBuilderMethodSpec methodSpec = new RootBuilderMethodSpec(finderMethod, finder.getDoc(), finderBuilderClass, rootBuilderSpec);
                finderBuilderClass.setRootBuilderMethod(methodSpec);
                finderSpecList.add(methodSpec);
            }
        }
        return finderSpecList;
    }

    private RestMethodBuilderSpec generateRestMethodRequestBuilder(ResourceSchema resource, String baseBuilderClass, String keyClass, String valueClass, String requestBuilderName, String clientPackage, RestMethodSchema schema) {
        RestMethodBuilderSpec restMethodBuilderClass = new RestMethodBuilderSpec(clientPackage, requestBuilderName, baseBuilderClass, resource, schema.getMethod());
        restMethodBuilderClass.setAnnotations(schema.getAnnotations() == null ? null : schema.getAnnotations().data());
        ClassTemplateSpec keyClassSpec = this.classToTemplateSpec(keyClass);
        restMethodBuilderClass.setKeyClass(keyClassSpec);
        ClassTemplateSpec valueClassSpec = this.classToTemplateSpec(valueClass);
        restMethodBuilderClass.setValueClass(valueClassSpec);
        this.registerBuilderSpec(restMethodBuilderClass);
        return restMethodBuilderClass;
    }

    private FinderBuilderSpec generateFinderRequestBuilder(ResourceSchema resource, String baseBuilderClass, String keyClass, String valueClass, String requestBuilderName, String clientPackage, String finderName, FinderSchema schema) {
        FinderBuilderSpec finderBuilderClass = new FinderBuilderSpec(clientPackage, requestBuilderName, baseBuilderClass, resource);
        finderBuilderClass.setAnnotations(schema.getAnnotations() == null ? null : schema.getAnnotations().data());
        ClassTemplateSpec keyClassSpec = this.classToTemplateSpec(keyClass);
        finderBuilderClass.setKeyClass(keyClassSpec);
        ClassTemplateSpec valueClassSpec = this.classToTemplateSpec(valueClass);
        finderBuilderClass.setValueClass(valueClassSpec);
        finderBuilderClass.setFinderName(finderName);
        this.registerBuilderSpec(finderBuilderClass);
        return finderBuilderClass;
    }

    private ActionBuilderSpec generateActionRequestBuilder(ResourceSchema resource, String baseBuilderClass, String keyClass, String returnType, String requestBuilderName, String clientPackage, ActionSchema schema) {
        ActionBuilderSpec actionBuilderClass = new ActionBuilderSpec(clientPackage, requestBuilderName, baseBuilderClass, resource, schema.getName());
        actionBuilderClass.setAnnotations(schema.getAnnotations() == null ? null : schema.getAnnotations().data());
        ClassTemplateSpec keyClassSpec = this.classToTemplateSpec(keyClass);
        actionBuilderClass.setKeyClass(keyClassSpec);
        ClassTemplateSpec returnClassSpec = this.classToTemplateSpec(returnType);
        actionBuilderClass.setValueClass(returnClassSpec);
        this.registerBuilderSpec(actionBuilderClass);
        return actionBuilderClass;
    }

    private List<RootBuilderMethodSpec> generateActions(RootBuilderSpec rootBuilderSpec, ActionSchemaArray actions, String keyClass, String resourceName, List<String> pathKeys, Map<String, String> pathKeyTypes) {
        ArrayList<RootBuilderMethodSpec> actionSpecList = new ArrayList<RootBuilderMethodSpec>();
        if (actions != null) {
            for (ActionSchema action : actions) {
                RootBuilderMethodSpec actionSpec = this.generateActionMethod(rootBuilderSpec, keyClass, action, resourceName, pathKeys, pathKeyTypes);
                actionSpecList.add(actionSpec);
            }
        }
        return actionSpecList;
    }

    private RootBuilderMethodSpec generateActionMethod(RootBuilderSpec rootBuilderSpec, String keyClass, ActionSchema action, String resourceName, List<String> pathKeys, Map<String, String> pathKeyTypes) {
        String actionName = action.getName();
        String returnType = action.getReturns();
        String actionBuilderClassName = CodeUtil.capitalize((String)resourceName) + "Do" + CodeUtil.capitalize((String)actionName) + this.getMethodBuilderSuffix();
        ActionBuilderSpec actionBuilderClass = this.generateActionRequestBuilder(rootBuilderSpec.getResource(), this.getBuilderBase(ResourceMethod.ACTION), keyClass, returnType, actionBuilderClassName, rootBuilderSpec.getNamespace(), action);
        if (action.hasParameters()) {
            this.generateActionParamBindingMethods(action.getParameters(), actionBuilderClass);
        }
        this.generatePathKeyBindingMethods(pathKeys, actionBuilderClass, pathKeyTypes);
        String actionMethodName = "action" + CodeUtil.capitalize((String)actionName);
        RootBuilderMethodSpec actionMethod = new RootBuilderMethodSpec(actionMethodName, action.getDoc(), actionBuilderClass, rootBuilderSpec);
        actionBuilderClass.setRootBuilderMethod(actionMethod);
        return actionMethod;
    }

    private List<RootBuilderMethodSpec> generateBasicMethods(RootBuilderSpec rootBuilderSpec, String keyClass, String valueClass, Set<ResourceMethod> supportedMethods, RestMethodSchemaArray restMethods, String resourceName, List<String> pathKeys, Map<String, String> pathKeyTypes) {
        HashMap<ResourceMethod, RestMethodSchema> schemaMap = new HashMap<ResourceMethod, RestMethodSchema>();
        if (restMethods != null) {
            for (RestMethodSchema restMethod : restMethods) {
                schemaMap.put(ResourceMethod.fromString((String)restMethod.getMethod()), restMethod);
            }
        }
        ArrayList<RootBuilderMethodSpec> methodSpecList = new ArrayList<RootBuilderMethodSpec>();
        for (Map.Entry<ResourceMethod, String> entry : this._builderBaseMap.entrySet()) {
            ResourceMethod method = entry.getKey();
            if (!supportedMethods.contains(method)) continue;
            String methodName = RestLiToolsUtils.normalizeUnderscores(method.toString());
            RestMethodSchema schema = (RestMethodSchema)schemaMap.get(method);
            RestMethodBuilderSpec requestBuilder = this.generateRestMethodRequestBuilder(rootBuilderSpec.getResource(), entry.getValue(), keyClass, valueClass, resourceName + RestLiToolsUtils.nameCapsCase(methodName) + this.getMethodBuilderSuffix(), rootBuilderSpec.getNamespace(), schema);
            this.generatePathKeyBindingMethods(pathKeys, requestBuilder, pathKeyTypes);
            if (schema != null && schema.hasParameters()) {
                this.generateQueryParamBindingMethods(schema.getParameters(), requestBuilder);
            }
            RootBuilderMethodSpec methodSpec = new RootBuilderMethodSpec(RestLiToolsUtils.nameCamelCase(methodName), schema.getDoc(), requestBuilder, rootBuilderSpec);
            requestBuilder.setRootBuilderMethod(methodSpec);
            methodSpecList.add(methodSpec);
        }
        return methodSpecList;
    }

    private void generatePathKeyBindingMethods(List<String> pathKeys, RequestBuilderSpec builderClass, Map<String, String> pathKeyTypes) {
        for (String pathKey : pathKeys) {
            PathKeyBindingMethodSpec spec = new PathKeyBindingMethodSpec();
            spec.setPathKey(pathKey);
            spec.setMethodName(RestLiToolsUtils.nameCamelCase(pathKey + "Key"));
            ClassTemplateSpec argTypeClassSpec = this.classToTemplateSpec(pathKeyTypes.get(pathKey));
            spec.setArgType(argTypeClassSpec);
            builderClass.addPathKeyMethod(spec);
        }
    }

    private void generateQueryParamBindingMethods(ParameterSchemaArray parameters, RequestBuilderSpec requestBuilderClass) {
        for (ParameterSchema param : parameters) {
            String paramName = param.getName();
            DataSchema typeSchema = RestSpecCodec.textToSchema((String)param.getType(), (DataSchemaResolver)this._schemaResolver);
            ClassTemplateSpec typeClassSpec = this.schemaToTemplateSpec(typeSchema);
            boolean isOptional = RestLiToolsUtils.isParameterOptional(param);
            String setMethodName = RestLiToolsUtils.nameCamelCase(paramName + "Param");
            QueryParamBindingMethodSpec spec = new QueryParamBindingMethodSpec(setMethodName);
            spec.setParamName(paramName);
            spec.setNeedAddParamMethod(false);
            spec.setOptional(isOptional);
            spec.setArgType(typeClassSpec);
            spec.setDoc(param.getDoc());
            requestBuilderClass.addQueryParamMethod(spec);
            if (!(typeSchema instanceof ArrayDataSchema)) continue;
            DataSchema itemsSchema = ((ArrayDataSchema)typeSchema).getItems();
            ClassTemplateSpec itemSpecClass = this.schemaToTemplateSpec(itemsSchema);
            String addMethodName = RestLiToolsUtils.nameCamelCase("add" + RestLiToolsUtils.normalizeCaps(paramName) + "Param");
            QueryParamBindingMethodSpec addSpec = new QueryParamBindingMethodSpec(addMethodName);
            addSpec.setParamName(paramName);
            addSpec.setNeedAddParamMethod(true);
            addSpec.setOptional(isOptional);
            addSpec.setArgType(itemSpecClass);
            addSpec.setDoc(param.getDoc());
            requestBuilderClass.addQueryParamMethod(addSpec);
        }
    }

    private void generateActionParamBindingMethods(ParameterSchemaArray parameters, ActionBuilderSpec requestBuilderClass) {
        for (ParameterSchema param : parameters) {
            String paramName = param.getName();
            ClassTemplateSpec typeClassSpec = this.classToTemplateSpec(param.getType());
            boolean isOptional = RestLiToolsUtils.isParameterOptional(param);
            String setMethodName = RestLiToolsUtils.nameCamelCase(paramName + "Param");
            ActionParamBindingMethodSpec spec = new ActionParamBindingMethodSpec(setMethodName);
            spec.setParamName(paramName);
            spec.setOptional(isOptional);
            spec.setArgType(typeClassSpec);
            spec.setDoc(param.getDoc());
            requestBuilderClass.addActionParamMethod(spec);
        }
    }

    private static String getResourcePath(String rawPath) {
        if (rawPath.charAt(0) == '/') {
            return rawPath.substring(1);
        }
        return rawPath;
    }

    private static Set<ResourceMethod> getSupportedMethods(StringArray supportsList) {
        if (supportsList == null) {
            return Collections.emptySet();
        }
        EnumSet<ResourceMethod> supportedMethods = EnumSet.noneOf(ResourceMethod.class);
        for (String methodEntry : supportsList) {
            supportedMethods.add(ResourceMethod.fromString((String)methodEntry));
        }
        return supportedMethods;
    }

    private ClassTemplateSpec classToTemplateSpec(String classname) {
        if (classname == null || "Void".equals(classname)) {
            return null;
        }
        DataSchema typeSchema = RestSpecCodec.textToSchema((String)classname, (DataSchemaResolver)this._schemaResolver);
        return this.schemaToTemplateSpec(typeSchema);
    }

    private ClassTemplateSpec schemaToTemplateSpec(DataSchema dataSchema) {
        return this._templateSpecGenerator.generate(dataSchema, this._currentSchemaLocation);
    }

    private String getMethodBuilderSuffix() {
        return this._customMethodBuilderSuffix == null ? METHOD_BUILDER_SUFFIX.get(this._version) : this._customMethodBuilderSuffix;
    }

    static {
        ROOT_BUILDERS_SUFFIX.put(RestliVersion.RESTLI_1_0_0, "Builders");
        ROOT_BUILDERS_SUFFIX.put(RestliVersion.RESTLI_2_0_0, "RequestBuilders");
        METHOD_BUILDER_SUFFIX = new HashMap<RestliVersion, String>();
        METHOD_BUILDER_SUFFIX.put(RestliVersion.RESTLI_1_0_0, "Builder");
        METHOD_BUILDER_SUFFIX.put(RestliVersion.RESTLI_2_0_0, "RequestBuilder");
    }
}

