/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.glu;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class TrustingSocketFactory
implements LayeredConnectionSocketFactory {
    private SSLContext sslcontext = null;

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, null);
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = TrustingSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, target, port, false);
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket();
    }

    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (connectTimeout == 0) {
            return socketfactory.createSocket(host.getHostName(), host.getPort(), localAddress.getAddress(), localAddress.getPort());
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress.getAddress(), localAddress.getPort());
        InetSocketAddress remoteaddr = new InetSocketAddress(remoteAddress.getAddress(), remoteAddress.getPort());
        socket.bind(localaddr);
        socket.connect(remoteaddr, connectTimeout);
        return socket;
    }
}

