/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.d2.balancer.util.HostSet;
import com.linkedin.d2.balancer.util.HostToKeyResult;
import com.linkedin.d2.balancer.util.KeysAndHosts;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HostToKeyMapper<K>
implements HostSet {
    private final Map<Integer, KeysAndHosts<K>> _partitionInfoMap;
    private final int _limitHostPerPartition;
    private final int _partitionCount;
    private final Set<HostToKeyResult.UnmappedKey<K>> _unmappedKeys;
    private final Map<Integer, Integer> _partitionsWithoutEnoughHosts;

    public HostToKeyMapper(Collection<K> unmappedKeys, Map<Integer, KeysAndHosts<K>> partitionInfoMap, int limitHostPerPartition, int partitionCount, Map<Integer, Integer> partitionsWithoutEnoughHosts) {
        if (limitHostPerPartition <= 0) {
            throw new IllegalArgumentException("MaxNumHost cannot be less than 1");
        }
        HashSet<HostToKeyResult.UnmappedKey<K>> unmappedKeysSet = new HashSet<HostToKeyResult.UnmappedKey<K>>();
        this._partitionInfoMap = Collections.unmodifiableMap(partitionInfoMap);
        this._limitHostPerPartition = limitHostPerPartition;
        this._partitionsWithoutEnoughHosts = partitionsWithoutEnoughHosts;
        this._partitionCount = partitionCount;
        for (K key : unmappedKeys) {
            unmappedKeysSet.add(new HostToKeyResult.UnmappedKey<K>(key, HostToKeyResult.ErrorType.FAIL_TO_FIND_PARTITION));
        }
        this._unmappedKeys = Collections.unmodifiableSet(unmappedKeysSet);
    }

    public HostToKeyResult<K> getResult(int whichIteration) {
        return this.doGetResult(whichIteration, this._partitionInfoMap, new HashSet<HostToKeyResult.UnmappedKey<K>>(this._unmappedKeys));
    }

    public HostToKeyResult<K> getResult(int whichIteration, Collection<K> keys) {
        HashMap<Integer, KeysAndHosts<Integer>> newPartitionInfoMap = new HashMap<Integer, KeysAndHosts<Integer>>();
        for (Map.Entry<Integer, KeysAndHosts<K>> entry : this._partitionInfoMap.entrySet()) {
            Collection<K> keysForPartition = entry.getValue().getKeys();
            ArrayList<K> newKeyList = new ArrayList<K>();
            for (K key : keysForPartition) {
                if (!keys.contains(key)) continue;
                newKeyList.add(key);
            }
            newPartitionInfoMap.put(entry.getKey(), new KeysAndHosts(newKeyList, entry.getValue().getHosts()));
        }
        return this.doGetResult(whichIteration, newPartitionInfoMap, new HashSet<HostToKeyResult.UnmappedKey<K>>(this._unmappedKeys));
    }

    private HostToKeyResult<K> doGetResult(int whichIteration, Map<Integer, KeysAndHosts<K>> partitionInfoMap, Collection<HostToKeyResult.UnmappedKey<K>> unmappedKeys) {
        if (whichIteration >= this._limitHostPerPartition) {
            return null;
        }
        HashMap hostToKeysMerge = new HashMap();
        for (Map.Entry<Integer, KeysAndHosts<K>> entry : partitionInfoMap.entrySet()) {
            Collection<K> keysForThisPartition = entry.getValue().getKeys();
            if (keysForThisPartition == null || keysForThisPartition.size() == 0) continue;
            List<URI> hosts = entry.getValue().getHosts();
            this.mergeKeys(hosts, keysForThisPartition, unmappedKeys, whichIteration, hostToKeysMerge);
        }
        return new HostToKeyResult(hostToKeysMerge, unmappedKeys);
    }

    private void mergeKeys(List<URI> hosts, Collection<K> keys, Collection<HostToKeyResult.UnmappedKey<K>> unmappedKeys, int whichIteration, Map<URI, Collection<K>> hostToKeysMerge) {
        if (whichIteration >= hosts.size()) {
            for (K key : keys) {
                unmappedKeys.add(new HostToKeyResult.UnmappedKey<K>(key, HostToKeyResult.ErrorType.NO_HOST_AVAILABLE_IN_PARTITION));
            }
        } else {
            URI currentHost = hosts.get(whichIteration);
            Collection<K> keysForCurrentHost = hostToKeysMerge.get(currentHost);
            if (keysForCurrentHost == null) {
                keysForCurrentHost = new HashSet<K>();
                hostToKeysMerge.put(currentHost, keysForCurrentHost);
            }
            keysForCurrentHost.addAll(keys);
        }
    }

    @Override
    public List<URI> getAllHosts() {
        HashSet<URI> hosts = new HashSet<URI>();
        for (Map.Entry<Integer, KeysAndHosts<K>> entry : this._partitionInfoMap.entrySet()) {
            hosts.addAll(entry.getValue().getHosts());
        }
        return new ArrayList<URI>(hosts);
    }

    @Override
    public List<URI> getHosts(int partitionId) {
        if (this._partitionInfoMap.containsKey(partitionId)) {
            return Collections.unmodifiableList(this._partitionInfoMap.get(partitionId).getHosts());
        }
        throw new IllegalArgumentException("PartitionId " + partitionId + " is not found");
    }

    @Override
    public int getPartitionCount() {
        return this._partitionCount;
    }

    @Override
    public Map<Integer, Integer> getPartitionsWithoutEnoughHosts() {
        return this._partitionsWithoutEnoughHosts;
    }

    public Map<Integer, KeysAndHosts<K>> getPartitionInfoMap() {
        return this._partitionInfoMap;
    }

    public int getLimitHostPerPartition() {
        return this._limitHostPerPartition;
    }

    public Set<HostToKeyResult.UnmappedKey<K>> getUnmappedKeys() {
        return this._unmappedKeys;
    }
}

