/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV3;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.d2.discovery.util.LogUtil;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyFactoryV3
implements LoadBalancerStrategyFactory<DegraderLoadBalancerStrategyV3> {
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerStrategyFactoryV3.class);
    private final HealthCheckOperations _healthCheckOperations;
    private final ScheduledExecutorService _executorService;

    public DegraderLoadBalancerStrategyFactoryV3() {
        this._healthCheckOperations = null;
        this._executorService = null;
    }

    public DegraderLoadBalancerStrategyFactoryV3(HealthCheckOperations healthCheckOperations, ScheduledExecutorService executorService) {
        this._healthCheckOperations = healthCheckOperations;
        this._executorService = executorService;
    }

    @Override
    public DegraderLoadBalancerStrategyV3 newLoadBalancer(String serviceName, Map<String, Object> strategyProperties, Map<String, String> degraderProperties) {
        LogUtil.debug(_log, "created a degrader load balancer strategyV3");
        DegraderLoadBalancerStrategyConfig config = DegraderLoadBalancerStrategyConfig.createHttpConfigFromMap(strategyProperties, this._healthCheckOperations, this._executorService);
        return new DegraderLoadBalancerStrategyV3(config, serviceName, degraderProperties);
    }
}

