/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;

public class TypedValue {
    public static final TypedValue NULL = new TypedValue(ColumnMetaData.Rep.OBJECT, null);
    public final ColumnMetaData.Rep type;
    public final Object value;

    private TypedValue(ColumnMetaData.Rep rep, Object value) {
        this.type = rep;
        this.value = value;
        assert (this.isSerial(rep, value)) : "rep: " + (Object)((Object)rep) + ", value: " + value;
    }

    private boolean isSerial(ColumnMetaData.Rep rep, Object value) {
        if (value == null) {
            return true;
        }
        switch (rep) {
            case BYTE_STRING: {
                return value instanceof String;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return value instanceof Integer;
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                return value instanceof Long;
            }
        }
        return true;
    }

    @JsonCreator
    public static TypedValue create(@JsonProperty(value="type") String type, @JsonProperty(value="value") Object value) {
        if (value == null) {
            return NULL;
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.valueOf(type);
        return TypedValue.ofLocal(rep, TypedValue.serialToLocal(rep, value));
    }

    public static TypedValue ofLocal(ColumnMetaData.Rep rep, Object value) {
        return new TypedValue(rep, TypedValue.localToSerial(rep, value));
    }

    public static TypedValue ofSerial(ColumnMetaData.Rep rep, Object value) {
        return new TypedValue(rep, value);
    }

    public static TypedValue ofJdbc(ColumnMetaData.Rep rep, Object value, Calendar calendar) {
        if (value == null) {
            return NULL;
        }
        return new TypedValue(rep, TypedValue.jdbcToSerial(rep, value, calendar));
    }

    public static TypedValue ofJdbc(Object value, Calendar calendar) {
        if (value == null) {
            return NULL;
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(value.getClass());
        return new TypedValue(rep, TypedValue.jdbcToSerial(rep, value, calendar));
    }

    public Object toLocal() {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToLocal(this.type, this.value);
    }

    private static Object serialToLocal(ColumnMetaData.Rep rep, Object value) {
        assert (value != null);
        if (value.getClass() == rep.clazz) {
            return value;
        }
        switch (rep) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case INTEGER: {
                return ((Number)value).intValue();
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: 
            case LONG: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case NUMBER: {
                return value instanceof BigDecimal ? value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double ? new BigDecimal((Double)value) : (value instanceof Float ? new BigDecimal(((Float)value).floatValue()) : new BigDecimal(((Number)value).longValue()))));
            }
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value);
            }
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to " + (Object)((Object)rep));
    }

    public Object toJdbc(Calendar calendar) {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToJdbc(this.type, this.value, calendar);
    }

    private static Object serialToJdbc(ColumnMetaData.Rep type, Object value, Calendar calendar) {
        switch (type) {
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value).getBytes();
            }
            case JAVA_UTIL_DATE: {
                return new Date(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_DATE: {
                return new java.sql.Date(TypedValue.adjust(((Number)value).longValue() * 86400000L, calendar));
            }
            case JAVA_SQL_TIME: {
                return new Time(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_TIMESTAMP: {
                return new Timestamp(TypedValue.adjust((Number)value, calendar));
            }
        }
        return TypedValue.serialToLocal(type, value);
    }

    private static long adjust(Number number, Calendar calendar) {
        long t = number.longValue();
        if (calendar != null) {
            t -= (long)calendar.getTimeZone().getOffset(t);
        }
        return t;
    }

    private static Object jdbcToSerial(ColumnMetaData.Rep rep, Object value, Calendar calendar) {
        switch (rep) {
            case BYTE_STRING: {
                return new ByteString((byte[])value).toBase64String();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                long t = ((Date)value).getTime();
                if (calendar != null) {
                    t += (long)calendar.getTimeZone().getOffset(t);
                }
                switch (rep) {
                    case JAVA_SQL_DATE: {
                        return (int)DateTimeUtils.floorDiv(t, 86400000L);
                    }
                    case JAVA_SQL_TIME: {
                        return (int)DateTimeUtils.floorMod(t, 86400000L);
                    }
                }
                return t;
            }
        }
        return value;
    }

    private static Object localToSerial(ColumnMetaData.Rep rep, Object value) {
        switch (rep) {
            case BYTE_STRING: {
                return ((ByteString)value).toBase64String();
            }
        }
        return value;
    }

    public static List<Object> values(List<TypedValue> typedValues) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TypedValue typedValue : typedValues) {
            list.add(typedValue.toLocal());
        }
        return list;
    }
}

