/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.calcite.avatica.util.ArrayIteratorCursor;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.calcite.avatica.util.IteratorCursor;
import org.apache.calcite.avatica.util.ListIteratorCursor;
import org.apache.calcite.avatica.util.MapIteratorCursor;
import org.apache.calcite.avatica.util.PositionedCursor;
import org.apache.calcite.avatica.util.RecordIteratorCursor;

public abstract class MetaImpl
implements Meta {
    protected final AvaticaConnection connection;
    protected final ConnectionPropertiesImpl connProps;

    public MetaImpl(AvaticaConnection connection) {
        this.connection = connection;
        this.connProps = new ConnectionPropertiesImpl();
    }

    public static Cursor createCursor(Meta.CursorFactory cursorFactory, Iterable<Object> iterable) {
        switch (cursorFactory.style) {
            case OBJECT: {
                return new IteratorCursor<Object>(iterable.iterator()){

                    @Override
                    protected AbstractCursor.Getter createGetter(int ordinal) {
                        return new PositionedCursor.ObjectGetter(ordinal);
                    }
                };
            }
            case ARRAY: {
                Iterable<Object> iterable1 = iterable;
                return new ArrayIteratorCursor((Iterator<Object[]>)iterable1.iterator());
            }
            case RECORD: {
                Class clazz = cursorFactory.clazz;
                return new RecordIteratorCursor<Object>(iterable.iterator(), clazz);
            }
            case RECORD_PROJECTION: {
                Class clazz2 = cursorFactory.clazz;
                return new RecordIteratorCursor<Object>(iterable.iterator(), clazz2, cursorFactory.fields);
            }
            case LIST: {
                Iterable<Object> iterable2 = iterable;
                return new ListIteratorCursor((Iterator<List<Object>>)iterable2.iterator());
            }
            case MAP: {
                Iterable<Object> iterable3 = iterable;
                return new MapIteratorCursor(iterable3.iterator(), cursorFactory.fieldNames);
            }
        }
        throw new AssertionError((Object)("unknown style: " + (Object)((Object)cursorFactory.style)));
    }

    public static List<List<Object>> collect(Meta.CursorFactory cursorFactory, final Iterator<Object> iterator, List<List<Object>> list) {
        Iterable<Object> iterable = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return iterator;
            }
        };
        return MetaImpl.collect(cursorFactory, iterable, list);
    }

    public static List<List<Object>> collect(Meta.CursorFactory cursorFactory, Iterable<Object> iterable, List<List<Object>> list) {
        switch (cursorFactory.style) {
            case OBJECT: {
                for (Object o : iterable) {
                    list.add(Collections.singletonList(o));
                }
                return list;
            }
            case ARRAY: {
                Iterable<Object> iterable1 = iterable;
                for (Object[] objectArray : iterable1) {
                    list.add(Arrays.asList(objectArray));
                }
                return list;
            }
            case RECORD: 
            case RECORD_PROJECTION: {
                Field[] fields;
                switch (cursorFactory.style) {
                    case RECORD: {
                        fields = cursorFactory.clazz.getFields();
                        break;
                    }
                    default: {
                        fields = cursorFactory.fields.toArray(new Field[cursorFactory.fields.size()]);
                    }
                }
                for (Object o : iterable) {
                    Object[] objectArray = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        try {
                            objectArray[i] = field.get(o);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    list.add(Arrays.asList(objectArray));
                }
                return list;
            }
            case LIST: {
                Iterable<Object> iterable2 = iterable;
                for (List list2 : iterable2) {
                    list.add(list2);
                }
                return list;
            }
            case MAP: {
                Iterable<Object> iterable3 = iterable;
                for (Map map : iterable3) {
                    ArrayList objects = new ArrayList();
                    for (String fieldName : cursorFactory.fieldNames) {
                        objects.add(map.get(fieldName));
                    }
                    list.add(objects);
                }
                return list;
            }
        }
        throw new AssertionError((Object)("unknown style: " + (Object)((Object)cursorFactory.style)));
    }

    @Override
    public void closeConnection(Meta.ConnectionHandle ch) {
    }

    @Override
    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        this.connProps.merge(connProps);
        this.connProps.setDirty(false);
        return this.connProps;
    }

    @Override
    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        return new Meta.StatementHandle(ch.id, this.connection.statementCount++, null);
    }

    protected <E> Meta.MetaResultSet createEmptyResultSet(Class<E> clazz) {
        return this.createResultSet(Collections.emptyMap(), MetaImpl.fieldMetaData(clazz).columns, Meta.CursorFactory.deduce(MetaImpl.fieldMetaData(clazz).columns, null), Meta.Frame.EMPTY);
    }

    protected static ColumnMetaData columnMetaData(String name, int index, Class<?> type) {
        TypeInfo pair = (TypeInfo)TypeInfo.m.get(type);
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.VALUE_MAP.get(type);
        ColumnMetaData.ScalarType scalarType = ColumnMetaData.scalar(pair.sqlType, pair.sqlTypeName, rep);
        return new ColumnMetaData(index, false, true, false, false, pair.primitive ? 1 : 0, true, -1, name, name, null, 0, 0, null, null, scalarType, true, false, false, scalarType.columnClassName());
    }

    protected static ColumnMetaData.StructType fieldMetaData(Class clazz) {
        ArrayList<ColumnMetaData> list = new ArrayList<ColumnMetaData>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            list.add(MetaImpl.columnMetaData(AvaticaUtils.camelToUpper(field.getName()), list.size() + 1, field.getType()));
        }
        return ColumnMetaData.struct(list);
    }

    protected Meta.MetaResultSet createResultSet(Map<String, Object> internalParameters, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, Meta.Frame firstFrame) {
        try {
            AvaticaStatement statement = this.connection.createStatement();
            Meta.Signature signature = new Meta.Signature(columns, "", Collections.emptyList(), internalParameters, cursorFactory);
            return Meta.MetaResultSet.create(this.connection.id, statement.getId(), true, signature, firstFrame);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties() {
        return Collections.emptyMap();
    }

    @Override
    public Meta.MetaResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        return this.createEmptyResultSet(MetaTable.class);
    }

    @Override
    public Meta.MetaResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaColumn.class);
    }

    @Override
    public Meta.MetaResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        return this.createEmptyResultSet(MetaSchema.class);
    }

    @Override
    public Meta.MetaResultSet getCatalogs() {
        return this.createEmptyResultSet(MetaCatalog.class);
    }

    @Override
    public Meta.MetaResultSet getTableTypes() {
        return this.createEmptyResultSet(MetaTableType.class);
    }

    @Override
    public Meta.MetaResultSet getProcedures(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        return this.createEmptyResultSet(MetaProcedure.class);
    }

    @Override
    public Meta.MetaResultSet getProcedureColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaProcedureColumn.class);
    }

    @Override
    public Meta.MetaResultSet getColumnPrivileges(String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaColumnPrivilege.class);
    }

    @Override
    public Meta.MetaResultSet getTablePrivileges(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return this.createEmptyResultSet(MetaTablePrivilege.class);
    }

    @Override
    public Meta.MetaResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return this.createEmptyResultSet(MetaBestRowIdentifier.class);
    }

    @Override
    public Meta.MetaResultSet getVersionColumns(String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaVersionColumn.class);
    }

    @Override
    public Meta.MetaResultSet getPrimaryKeys(String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaPrimaryKey.class);
    }

    @Override
    public Meta.MetaResultSet getImportedKeys(String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaImportedKey.class);
    }

    @Override
    public Meta.MetaResultSet getExportedKeys(String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaExportedKey.class);
    }

    @Override
    public Meta.MetaResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return this.createEmptyResultSet(MetaCrossReference.class);
    }

    @Override
    public Meta.MetaResultSet getTypeInfo() {
        return this.createEmptyResultSet(MetaTypeInfo.class);
    }

    @Override
    public Meta.MetaResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return this.createEmptyResultSet(MetaIndexInfo.class);
    }

    @Override
    public Meta.MetaResultSet getUDTs(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return this.createEmptyResultSet(MetaUdt.class);
    }

    @Override
    public Meta.MetaResultSet getSuperTypes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return this.createEmptyResultSet(MetaSuperType.class);
    }

    @Override
    public Meta.MetaResultSet getSuperTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return this.createEmptyResultSet(MetaSuperTable.class);
    }

    @Override
    public Meta.MetaResultSet getAttributes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return this.createEmptyResultSet(MetaAttribute.class);
    }

    @Override
    public Meta.MetaResultSet getClientInfoProperties() {
        return this.createEmptyResultSet(MetaClientInfoProperty.class);
    }

    @Override
    public Meta.MetaResultSet getFunctions(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return this.createEmptyResultSet(MetaFunction.class);
    }

    @Override
    public Meta.MetaResultSet getFunctionColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaFunctionColumn.class);
    }

    @Override
    public Meta.MetaResultSet getPseudoColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaPseudoColumn.class);
    }

    @Override
    public Iterable<Object> createIterable(Meta.StatementHandle handle, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        if (firstFrame != null && firstFrame.done) {
            return firstFrame.rows;
        }
        return new FetchIterable(handle, firstFrame, parameterValues);
    }

    @Override
    public Meta.Frame fetch(Meta.StatementHandle h, List<TypedValue> parameterValues, int offset, int fetchMaxRowCount) {
        return null;
    }

    private class FetchIterator
    implements Iterator<Object> {
        private final Meta.StatementHandle handle;
        private Meta.Frame frame;
        private Iterator<Object> rows;
        private List<TypedValue> parameterValues;

        public FetchIterator(Meta.StatementHandle handle, Meta.Frame firstFrame, List<TypedValue> parameterValues) {
            this.handle = handle;
            this.parameterValues = parameterValues;
            if (firstFrame == null) {
                this.frame = Meta.Frame.MORE;
                this.rows = EmptyIterator.INSTANCE;
            } else {
                this.frame = firstFrame;
                this.rows = firstFrame.rows.iterator();
            }
            this.moveNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.rows != null;
        }

        @Override
        public Object next() {
            if (this.rows == null) {
                throw new NoSuchElementException();
            }
            Object o = this.rows.next();
            this.moveNext();
            return o;
        }

        private void moveNext() {
            while (!this.rows.hasNext()) {
                if (this.frame.done) {
                    this.rows = null;
                    break;
                }
                this.frame = MetaImpl.this.fetch(this.handle, this.parameterValues, this.frame.offset, 100);
                this.parameterValues = null;
                if (this.frame == null) {
                    this.rows = null;
                    break;
                }
                this.rows = this.frame.rows.iterator();
            }
        }
    }

    private class FetchIterable
    implements Iterable<Object> {
        private final Meta.StatementHandle handle;
        private final Meta.Frame firstFrame;
        private final List<TypedValue> parameterValues;

        public FetchIterable(Meta.StatementHandle handle, Meta.Frame firstFrame, List<TypedValue> parameterValues) {
            this.handle = handle;
            this.firstFrame = firstFrame;
            this.parameterValues = parameterValues;
        }

        @Override
        public Iterator<Object> iterator() {
            return new FetchIterator(this.handle, this.firstFrame, this.parameterValues);
        }
    }

    private static class EmptyIterator
    implements Iterator<Object> {
        public static final Iterator<Object> INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private static class TypeInfo {
        private static Map<Class<?>, TypeInfo> m = new HashMap();
        private final boolean primitive;
        private final int sqlType;
        private final String sqlTypeName;

        public TypeInfo(boolean primitive, int sqlType, String sqlTypeName) {
            this.primitive = primitive;
            this.sqlType = sqlType;
            this.sqlTypeName = sqlTypeName;
        }

        static void put(Class clazz, boolean primitive, int sqlType, String sqlTypeName) {
            m.put(clazz, new TypeInfo(primitive, sqlType, sqlTypeName));
        }

        static {
            TypeInfo.put(Boolean.TYPE, true, 16, "BOOLEAN");
            TypeInfo.put(Boolean.class, false, 16, "BOOLEAN");
            TypeInfo.put(Byte.TYPE, true, -6, "TINYINT");
            TypeInfo.put(Byte.class, false, -6, "TINYINT");
            TypeInfo.put(Short.TYPE, true, 5, "SMALLINT");
            TypeInfo.put(Short.class, false, 5, "SMALLINT");
            TypeInfo.put(Integer.TYPE, true, 4, "INTEGER");
            TypeInfo.put(Integer.class, false, 4, "INTEGER");
            TypeInfo.put(Long.TYPE, true, -5, "BIGINT");
            TypeInfo.put(Long.class, false, -5, "BIGINT");
            TypeInfo.put(Float.TYPE, true, 6, "FLOAT");
            TypeInfo.put(Float.class, false, 6, "FLOAT");
            TypeInfo.put(Double.TYPE, true, 8, "DOUBLE");
            TypeInfo.put(Double.class, false, 8, "DOUBLE");
            TypeInfo.put(String.class, false, 12, "VARCHAR");
            TypeInfo.put(Date.class, false, 91, "DATE");
            TypeInfo.put(Time.class, false, 92, "TIME");
            TypeInfo.put(Timestamp.class, false, 93, "TIMESTAMP");
        }
    }

    public static class MetaSuperTable {
    }

    public static class MetaPseudoColumn {
    }

    public static class MetaFunctionColumn {
    }

    public static class MetaFunction {
    }

    public static class MetaClientInfoProperty {
    }

    public static class MetaAttribute {
    }

    public static class MetaSuperType {
    }

    public static class MetaUdt {
    }

    public static class MetaIndexInfo {
    }

    public static class MetaTypeInfo {
    }

    public static class MetaCrossReference {
    }

    public static class MetaExportedKey {
    }

    public static class MetaImportedKey {
    }

    public static class MetaPrimaryKey {
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String columnName;
        public final short keySeq;
        public final String pkName;

        MetaPrimaryKey(String tableCat, String tableSchem, String tableName, String columnName, short keySeq, String pkName) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.keySeq = keySeq;
            this.pkName = pkName;
        }
    }

    public static class MetaVersionColumn {
        public final short scope;
        public final String columnName;
        public final int dataType;
        public final String typeName;
        public final int columnSize;
        public final int bufferLength;
        public final short decimalDigits;
        public final short pseudoColumn;

        MetaVersionColumn(short scope, String columnName, int dataType, String typeName, int columnSize, int bufferLength, short decimalDigits, short pseudoColumn) {
            this.scope = scope;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.bufferLength = bufferLength;
            this.decimalDigits = decimalDigits;
            this.pseudoColumn = pseudoColumn;
        }
    }

    public static class MetaBestRowIdentifier {
    }

    public static class MetaTablePrivilege {
    }

    public static class MetaColumnPrivilege {
    }

    public static class MetaProcedureColumn {
    }

    public static class MetaProcedure {
    }

    public static class MetaTableType {
        public final String tableType;

        public MetaTableType(String tableType) {
            this.tableType = tableType;
        }
    }

    public static class MetaCatalog
    implements Named {
        public final String tableCatalog;

        public MetaCatalog(String tableCatalog) {
            this.tableCatalog = tableCatalog;
        }

        @Override
        public String getName() {
            return this.tableCatalog;
        }
    }

    public static class MetaSchema
    implements Named {
        public final String tableCatalog;
        public final String tableSchem;

        public MetaSchema(String tableCatalog, String tableSchem) {
            this.tableCatalog = tableCatalog;
            this.tableSchem = tableSchem;
        }

        @Override
        public String getName() {
            return this.tableSchem;
        }
    }

    public static class MetaTable
    implements Named {
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String tableType;
        public final String remarks;
        public final String typeCat;
        public final String typeSchem;
        public final String typeName;
        public final String selfReferencingColName;
        public final String refGeneration;

        public MetaTable(String tableCat, String tableSchem, String tableName, String tableType) {
            this.remarks = null;
            this.typeCat = null;
            this.typeSchem = null;
            this.typeName = null;
            this.selfReferencingColName = null;
            this.refGeneration = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.tableType = tableType;
        }

        @Override
        public String getName() {
            return this.tableName;
        }
    }

    public static class MetaColumn
    implements Named {
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String columnName;
        public final int dataType;
        public final String typeName;
        public final int columnSize;
        public final String bufferLength;
        public final Integer decimalDigits;
        public final int numPrecRadix;
        public final int nullable;
        public final String remarks;
        public final String columnDef;
        public final String sqlDataType;
        public final String sqlDatetimeSub;
        public final int charOctetLength;
        public final int ordinalPosition;
        public final String isNullable;
        public final String scopeCatalog;
        public final String scopeTable;
        public final String sourceDataType;
        public final String isAutoincrement;
        public final String isGeneratedcolumn;

        public MetaColumn(String tableCat, String tableSchem, String tableName, String columnName, int dataType, String typeName, int columnSize, Integer decimalDigits, int numPrecRadix, int nullable, int charOctetLength, int ordinalPosition, String isNullable) {
            this.bufferLength = null;
            this.remarks = null;
            this.columnDef = null;
            this.sqlDataType = null;
            this.sqlDatetimeSub = null;
            this.scopeCatalog = null;
            this.scopeTable = null;
            this.sourceDataType = null;
            this.isAutoincrement = null;
            this.isGeneratedcolumn = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
            this.nullable = nullable;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
        }

        @Override
        public String getName() {
            return this.columnName;
        }
    }

    public static interface Named {
        @JsonIgnore
        public String getName();
    }
}

