/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.hadoop.hive.metastore.api.Table;

public class TableDeregisterStep
implements CommitStep {
    private Table table;
    private final Optional<String> metastoreURI;
    private final HiveRegProps props;

    public boolean isCompleted() throws IOException {
        return false;
    }

    public void execute() throws IOException {
        try (HiveRegister hiveRegister = HiveRegister.get(this.props, this.metastoreURI);){
            hiveRegister.dropTableIfExists(this.table.getDbName(), this.table.getTableName());
        }
    }

    public String toString() {
        return String.format("Deregister table %s.%s on Hive metastore %s.", this.table.getDbName(), this.table.getTableName(), this.metastoreURI.isPresent() ? this.metastoreURI.get() : "default");
    }

    @ConstructorProperties(value={"table", "metastoreURI", "props"})
    public TableDeregisterStep(Table table, Optional<String> metastoreURI, HiveRegProps props) {
        this.table = table;
        this.metastoreURI = metastoreURI;
        this.props = props;
    }
}

