/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.hive.HiveRegistrationUnit;

@Alpha
public class HivePartition
extends HiveRegistrationUnit {
    private final List<String> values;

    private HivePartition(Builder builder) {
        super(builder);
        this.values = ImmutableList.copyOf((Collection)builder.values);
    }

    @Override
    public String toString() {
        return super.toString() + " Values: " + this.values.toString();
    }

    public List<String> getValues() {
        return this.values;
    }

    public static class Builder
    extends HiveRegistrationUnit.Builder<Builder> {
        private List<String> values = Lists.newArrayList();

        public Builder withPartitionValues(List<String> values) {
            this.values = values;
            return this;
        }

        @Override
        public HivePartition build() {
            return new HivePartition(this);
        }
    }
}

