/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PathSpec {
    public static final String WILDCARD = new String("*");
    private final List<String> _path;
    private static final PathSpec EMPTY_PATH_SPEC = new PathSpec();
    private static final char SEPARATOR = '/';

    public PathSpec(List<String> parentPath, String segment) {
        this._path = new ArrayList<String>(parentPath.size() + 1);
        this._path.addAll(parentPath);
        this._path.add(segment);
    }

    public PathSpec(String segment) {
        this._path = new ArrayList<String>(1);
        this._path.add(segment);
    }

    public PathSpec(String ... segments) {
        this._path = new ArrayList<String>(Arrays.asList(segments));
    }

    public PathSpec() {
        this._path = Collections.emptyList();
    }

    public static PathSpec emptyPath() {
        return EMPTY_PATH_SPEC;
    }

    public List<String> getPathComponents() {
        return Collections.unmodifiableList(this._path);
    }

    public String toString() {
        StringBuilder rep = new StringBuilder();
        for (String s : this.getPathComponents()) {
            rep.append('/');
            rep.append(s);
        }
        return rep.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathSpec) {
            PathSpec other = (PathSpec)obj;
            if (other._path.size() != this._path.size()) {
                return false;
            }
            for (int ii = 0; ii < this._path.size(); ++ii) {
                if (this._path.get(ii) == WILDCARD != (other._path.get(ii) == WILDCARD)) {
                    return false;
                }
                if (this._path.get(ii).equals(other._path.get(ii))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }
}

