/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.element.DataElement;
import com.linkedin.data.it.Predicate;
import com.linkedin.data.it.Wildcard;
import com.linkedin.data.schema.PathSpec;
import java.util.ArrayList;
import java.util.List;

public class PathMatchesPatternPredicate
implements Predicate {
    private final Object[] _patterns;
    private final List<Match> _matches = new ArrayList<Match>();

    public PathMatchesPatternPredicate(Object ... patterns) throws IllegalArgumentException {
        this._patterns = patterns;
        this.generateComponentMatches();
    }

    public PathMatchesPatternPredicate(PathSpec pathSpec) throws IllegalArgumentException {
        this(PathMatchesPatternPredicate.pathSpecToPathMatchPattern(pathSpec));
    }

    private static Object[] pathSpecToPathMatchPattern(PathSpec pathSpec) {
        List<String> pathComponents = pathSpec.getPathComponents();
        Object[] results = new Object[pathComponents.size()];
        int i = 0;
        for (String pathComponent : pathComponents) {
            if (pathComponent == PathSpec.WILDCARD) {
                results[i++] = Wildcard.ANY_ONE;
                continue;
            }
            results[i++] = pathComponent;
        }
        return results;
    }

    @Override
    public boolean evaluate(DataElement element) {
        return this.pass(element, 0);
    }

    /*
     * Unable to fully structure code
     */
    private boolean pass(DataElement element, int i) {
        pass = true;
        currentElement = element;
        while (i < this._matches.size()) {
            match = this._matches.get(i);
            if (match.name != null) ** GOTO lbl36
            for (d = 0; d < match.minDistance; ++d) {
                if (currentElement.getParent() == null) {
                    pass = false;
                    break;
                }
                currentElement = currentElement.getParent();
            }
            if (!pass) break;
            if (i == this._matches.size() - 1) {
                while (d < match.maxDistance && currentElement.getParent() != null) {
                    currentElement = currentElement.getParent();
                    ++d;
                }
            } else {
                nextMatch = this._matches.get(i + 1);
                searchDistance = match.maxDistance == 0x7FFFFFFF ? 0x7FFFFFFF : match.maxDistance - match.minDistance + 1;
                matched = false;
                while (searchDistance > 0 && currentElement.getParent() != null) {
                    if (this.matchName(nextMatch, currentElement.getName()) && (subPass = this.pass(currentElement.getParent(), i + 2))) {
                        matched = true;
                        i = this._matches.size();
                        while (currentElement.getParent() != null) {
                            currentElement = currentElement.getParent();
                        }
                        break;
                    }
                    --searchDistance;
                    currentElement = currentElement.getParent();
                }
                if (matched) break;
                pass = false;
                break;
lbl36:
                // 1 sources

                if (currentElement.getParent() == null || !this.matchName(match, currentElement.getName())) {
                    pass = false;
                    break;
                }
                currentElement = currentElement.getParent();
            }
            ++i;
        }
        if (pass) {
            if (!PathMatchesPatternPredicate.$assertionsDisabled && i != this._matches.size()) {
                throw new AssertionError();
            }
            pass = currentElement.getParent() == null;
        }
        return pass;
    }

    private boolean matchName(Match match, Object name) {
        return match.name.equals(name);
    }

    private void generateComponentMatches() throws IllegalArgumentException {
        for (int i = this._patterns.length - 1; i >= 0; --i) {
            Match match = new Match();
            Object component = this._patterns[i];
            Class<?> componentClass = component.getClass();
            if (componentClass == Wildcard.class) {
                match.name = null;
                match.minDistance = 0;
                match.maxDistance = 0;
                while (i >= 0 && (component = this._patterns[i]).getClass() == Wildcard.class) {
                    Wildcard w = (Wildcard)((Object)component);
                    switch (w) {
                        case ANY_ZERO_OR_MORE: {
                            match.maxDistance = Integer.MAX_VALUE;
                            break;
                        }
                        case ANY_ZERO_OR_ONE: {
                            if (match.maxDistance == Integer.MAX_VALUE) break;
                            ++match.maxDistance;
                            break;
                        }
                        case ANY_ONE_OR_MORE: {
                            if (match.minDistance != Integer.MAX_VALUE) {
                                ++match.minDistance;
                            }
                            match.maxDistance = Integer.MAX_VALUE;
                            break;
                        }
                        case ANY_ONE: {
                            ++match.minDistance;
                            if (match.maxDistance == Integer.MAX_VALUE) break;
                            ++match.maxDistance;
                        }
                    }
                    --i;
                }
                ++i;
                assert (match.minDistance <= match.maxDistance);
            } else if (componentClass == String.class || componentClass == Integer.class) {
                match.name = component;
            } else {
                throw new IllegalArgumentException("Component is not a String, Integer, or Wildcard: " + component);
            }
            this._matches.add(match);
        }
    }

    private static final class Match {
        Object name;
        int minDistance;
        int maxDistance;

        private Match() {
        }
    }
}

