/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingConverter
extends Converter<Object, Object, Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(SamplingConverter.class);
    public static final String SAMPLE_RATIO_KEY = "converter.sample.ratio";
    public static final double DEFAULT_SAMPLE_RATIO = 0.01;
    private final Random random = new Random();
    private double sampleRatio = 0.01;

    public Converter<Object, Object, Object, Object> init(WorkUnitState workUnit) {
        super.init(workUnit);
        try {
            Config config = ConfigUtils.propertiesToConfig((Properties)workUnit.getProperties());
            double sampleRatio = ConfigUtils.getDouble((Config)config, (String)SAMPLE_RATIO_KEY, (double)0.01);
            Preconditions.checkState((sampleRatio >= 0.0 && sampleRatio <= 1.0 ? 1 : 0) != 0, (Object)("Sample ratio must be between 0.0 and 1.0. Found " + sampleRatio));
            this.sampleRatio = sampleRatio;
        }
        catch (Exception e) {
            log.warn("Unable to retrieve config", (Throwable)e);
            log.warn("Defaulting to default sample ratio: {}", (Object)this.sampleRatio);
        }
        log.debug("Sample ratio configured: {}", (Object)this.sampleRatio);
        return this;
    }

    public Object convertSchema(Object inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<Object> convertRecord(Object outputSchema, Object inputRecord, WorkUnitState workUnit) throws DataConversionException {
        if (this.random.nextDouble() <= this.sampleRatio) {
            return new SingleRecordIterable<Object>(inputRecord);
        }
        return Collections.EMPTY_LIST;
    }
}

