/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter.request;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.transform.DataComplexProcessor;
import com.linkedin.data.transform.DataProcessingException;
import com.linkedin.data.transform.Escaper;
import com.linkedin.data.transform.filter.MaskComposition;
import com.linkedin.data.transform.filter.request.MaskOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaskTree {
    private DataMap _representation;

    public MaskTree() {
        this._representation = new DataMap();
    }

    public MaskTree(DataMap rep) {
        this._representation = rep;
    }

    public void addOperation(PathSpec path, MaskOperation op) {
        DataMap fieldMask;
        List segments = path.getPathComponents();
        DataMap map = fieldMask = new DataMap();
        for (int ii = 0; ii < segments.size() - 1; ++ii) {
            String segment = Escaper.escapePathSegment((String)segments.get(ii));
            DataMap childMap = new DataMap();
            map.put((Object)segment, (Object)childMap);
            map = childMap;
        }
        String lastSegment = Escaper.escapePathSegment((String)segments.get(segments.size() - 1));
        map.put((Object)lastSegment, (Object)op.getRepresentation());
        try {
            new DataComplexProcessor(new MaskComposition(), fieldMask, (DataComplex)this._representation).run(false);
        }
        catch (DataProcessingException e) {
            throw new IllegalStateException("error while building mask tree", e);
        }
    }

    public Map<PathSpec, MaskOperation> getOperations() {
        HashMap<PathSpec, MaskOperation> result = new HashMap<PathSpec, MaskOperation>();
        this.getOperationsImpl(this._representation, PathSpec.emptyPath(), result);
        return result;
    }

    public DataMap getDataMap() {
        return this._representation;
    }

    private void getOperationsImpl(DataMap data, PathSpec path, Map<PathSpec, MaskOperation> result) {
        for (Map.Entry entry : data.entrySet()) {
            String segment = Escaper.unescapePathSegment((String)entry.getKey());
            PathSpec subpath = new PathSpec(path.getPathComponents(), segment);
            Object value = entry.getValue();
            if (value instanceof Integer) {
                if (value.equals(MaskOperation.NEGATIVE_MASK_OP.getRepresentation())) {
                    result.put(subpath, MaskOperation.NEGATIVE_MASK_OP);
                    continue;
                }
                if (value.equals(MaskOperation.POSITIVE_MASK_OP.getRepresentation())) {
                    result.put(subpath, MaskOperation.POSITIVE_MASK_OP);
                    continue;
                }
                throw new IllegalStateException("invalid mask tree");
            }
            if (value.getClass() == DataMap.class) {
                this.getOperationsImpl((DataMap)value, subpath, result);
                continue;
            }
            throw new IllegalStateException("invalid mask tree");
        }
    }

    public String toString() {
        return this._representation.toString();
    }
}

