/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.state;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.Constructs;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;

public class ConstructState
extends State {
    private static final Gson GSON = new Gson();
    private static Type TYPE_OF_HASHMAP = new TypeToken<Map<String, String>>(){}.getType();
    private static final String OVERWRITE_PROPS_KEY = "gobblin.util.final.state.overwrite.props";
    private static final String FINAL_CONSTRUCT_STATE_PREFIX = "construct.final.state.";

    public ConstructState() {
    }

    public ConstructState(Properties properties) {
        super(properties);
    }

    public ConstructState(State otherState) {
        super(otherState);
    }

    public void addOverwriteProperties(Map<String, String> properties) {
        Map<String, String> previousOverwriteProps = this.getOverwritePropertiesMap();
        previousOverwriteProps.putAll(properties);
        this.setProp(OVERWRITE_PROPS_KEY, ConstructState.serializeMap(previousOverwriteProps));
    }

    public void addOverwriteProperties(State state) {
        HashMap propsMap = Maps.newHashMap();
        for (String key : state.getPropertyNames()) {
            propsMap.put(key, state.getProp(key));
        }
        this.addOverwriteProperties(propsMap);
    }

    public void addConstructState(Constructs construct, ConstructState constructState) {
        this.addConstructState(construct, constructState, (Optional<String>)Optional.absent());
    }

    public void addConstructState(Constructs construct, ConstructState constructState, String infix) {
        this.addConstructState(construct, constructState, (Optional<String>)Optional.of((Object)infix));
    }

    public void addConstructState(Constructs construct, ConstructState constructState, Optional<String> infix) {
        this.addOverwriteProperties(constructState.getOverwritePropertiesMap());
        constructState.removeProp(OVERWRITE_PROPS_KEY);
        for (String key : constructState.getPropertyNames()) {
            this.setProp(construct.name() + "." + (infix.isPresent() ? (String)infix.get() + "." : "") + key, constructState.getProp(key));
        }
        this.addAll(constructState);
    }

    public void mergeIntoWorkUnitState(WorkUnitState state) {
        Properties overwriteProperties = this.getOverwriteProperties();
        state.addAll(overwriteProperties);
        this.removeProp(OVERWRITE_PROPS_KEY);
        for (String key : this.getPropertyNames()) {
            state.setProp(FINAL_CONSTRUCT_STATE_PREFIX + key, (Object)this.getProp(key));
        }
    }

    public Map<String, String> getOverwritePropertiesMap() {
        return this.contains(OVERWRITE_PROPS_KEY) ? ConstructState.deserializeMap(this.getProp(OVERWRITE_PROPS_KEY)) : Maps.newHashMap();
    }

    public Properties getOverwriteProperties() {
        Properties props = new Properties();
        props.putAll(this.getOverwritePropertiesMap());
        return props;
    }

    private static String serializeMap(Map<String, String> map) {
        return GSON.toJson(map);
    }

    private static Map<String, String> deserializeMap(String string) {
        return (Map)GSON.fromJson(string, TYPE_OF_HASHMAP);
    }
}

