/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.qualitychecker.row;

import com.google.common.base.Strings;
import com.google.common.io.Closer;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.qualitychecker.row.RowLevelErrFileWriter;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicyCheckResults;
import org.apache.gobblin.records.ControlMessageHandler;
import org.apache.gobblin.records.RecordStreamProcessor;
import org.apache.gobblin.records.RecordStreamWithMetadata;
import org.apache.gobblin.stream.ControlMessage;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.util.FinalState;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RowLevelPolicyChecker<S, D>
implements Closeable,
FinalState,
RecordStreamProcessor<S, S, D, D> {
    private final List<RowLevelPolicy> list;
    private final String stateId;
    private final FileSystem fs;
    private boolean errFileOpen;
    private final Closer closer;
    private final FrontLoadedSampler sampler;
    private RowLevelErrFileWriter writer;
    private final RowLevelPolicyCheckResults results;

    public RowLevelPolicyChecker(List<RowLevelPolicy> list, String stateId, FileSystem fs) {
        this(list, stateId, fs, new State());
    }

    public RowLevelPolicyChecker(List<RowLevelPolicy> list, String stateId, FileSystem fs, State state) {
        this.list = list;
        this.stateId = stateId;
        this.fs = fs;
        this.errFileOpen = false;
        this.closer = Closer.create();
        this.writer = (RowLevelErrFileWriter)this.closer.register((Closeable)new RowLevelErrFileWriter(this.fs));
        this.results = new RowLevelPolicyCheckResults();
        this.sampler = new FrontLoadedSampler(state.getPropAsLong("qualitychecker.row.errFile.recordsPerTask", 1000000L), 1.5);
    }

    public boolean executePolicies(Object record, RowLevelPolicyCheckResults results) throws IOException {
        for (RowLevelPolicy p : this.list) {
            RowLevelPolicy.Result result = p.executePolicy(record);
            results.put(p, result);
            if (!result.equals((Object)RowLevelPolicy.Result.FAILED)) continue;
            if (p.getType().equals((Object)RowLevelPolicy.Type.FAIL)) {
                throw new RuntimeException("RowLevelPolicy " + p + " failed on record " + record);
            }
            if (p.getType().equals((Object)RowLevelPolicy.Type.ERR_FILE) && this.sampler.acceptNext()) {
                if (!this.errFileOpen) {
                    this.writer.open(this.getErrFilePath(p));
                    this.writer.write(record);
                } else {
                    this.writer.write(record);
                }
                this.errFileOpen = true;
            }
            return false;
        }
        return true;
    }

    private Path getErrFilePath(RowLevelPolicy policy) {
        String errFileName = HadoopUtils.sanitizePath((String)policy.toString(), (String)"-");
        if (!Strings.isNullOrEmpty((String)this.stateId)) {
            errFileName = errFileName + "-" + this.stateId;
        }
        errFileName = errFileName + ".err";
        return new Path(policy.getErrFileLocation(), errFileName);
    }

    @Override
    public void close() throws IOException {
        if (this.errFileOpen) {
            this.closer.close();
        }
    }

    public State getFinalState() {
        State state = new State();
        for (RowLevelPolicy policy : this.list) {
            state.addAll(policy.getFinalState());
        }
        return state;
    }

    public RecordStreamWithMetadata<D, S> processStream(RecordStreamWithMetadata<D, S> inputStream, WorkUnitState state) {
        Flowable filteredStream = inputStream.getRecordStream().filter(r -> {
            if (r instanceof ControlMessage) {
                this.getMessageHandler().handleMessage((ControlMessage)r);
                return true;
            }
            if (r instanceof RecordEnvelope) {
                boolean accept = this.executePolicies(((RecordEnvelope)r).getRecord(), this.results);
                if (!accept) {
                    r.ack();
                }
                return accept;
            }
            return true;
        });
        filteredStream = filteredStream.doFinally(this::close);
        return inputStream.withRecordStream(filteredStream);
    }

    protected ControlMessageHandler getMessageHandler() {
        return ControlMessageHandler.NOOP;
    }

    public RowLevelPolicyCheckResults getResults() {
        return this.results;
    }

    @ThreadSafe
    static class FrontLoadedSampler {
        private final long targetRecordsAccepted;
        private final double decayFactor;
        private final AtomicLong errorRecords = new AtomicLong();
        private final AtomicLong nextErrorRecordWritten = new AtomicLong();

        public FrontLoadedSampler(long targetRecordsAccepted, double decayFactor) {
            this.targetRecordsAccepted = targetRecordsAccepted;
            this.decayFactor = Math.max(1.0, decayFactor);
            if (this.targetRecordsAccepted <= 0L) {
                this.nextErrorRecordWritten.set(Long.MAX_VALUE);
            }
        }

        public boolean acceptNext() {
            long recordNum = this.errorRecords.getAndIncrement();
            while (recordNum >= this.nextErrorRecordWritten.get()) {
                if (!this.nextErrorRecordWritten.compareAndSet(recordNum, this.computeNextErrorRecordWritten())) continue;
                return true;
            }
            return false;
        }

        private long computeNextErrorRecordWritten() {
            long current = this.nextErrorRecordWritten.get();
            if (current < this.targetRecordsAccepted) {
                return current + 1L;
            }
            return (long)(this.decayFactor * (double)current) + 1L;
        }
    }
}

