/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.converter.json.JsonSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStringToJsonIntermediateConverter
extends Converter<String, JsonArray, String, JsonObject> {
    private static final Logger log = LoggerFactory.getLogger(JsonStringToJsonIntermediateConverter.class);
    private static final String UNPACK_COMPLEX_SCHEMAS_KEY = "gobblin.converter.jsonStringToJsonIntermediate.unpackComplexSchemas";
    public static final boolean DEFAULT_UNPACK_COMPLEX_SCHEMAS_KEY = Boolean.TRUE;
    private boolean unpackComplexSchemas;

    public JsonArray convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        this.unpackComplexSchemas = workUnit.getPropAsBoolean(UNPACK_COMPLEX_SCHEMAS_KEY, DEFAULT_UNPACK_COMPLEX_SCHEMAS_KEY);
        JsonParser jsonParser = new JsonParser();
        log.info("Schema: " + inputSchema);
        JsonElement jsonSchema = jsonParser.parse(inputSchema);
        return jsonSchema.getAsJsonArray();
    }

    public Iterable<JsonObject> convertRecord(JsonArray outputSchema, String strInputRecord, WorkUnitState workUnit) throws DataConversionException {
        JsonParser jsonParser = new JsonParser();
        JsonObject inputRecord = (JsonObject)jsonParser.parse(strInputRecord);
        if (!this.unpackComplexSchemas) {
            return new SingleRecordIterable((Object)inputRecord);
        }
        JsonSchema schema = new JsonSchema(outputSchema);
        JsonObject rec = this.parse(inputRecord, schema);
        return new SingleRecordIterable((Object)rec);
    }

    private JsonElement parse(JsonElement element, JsonSchema schema) throws DataConversionException {
        JsonObject root = new JsonObject();
        root.add("root", element);
        JsonObject jsonObject = this.parse(root, schema);
        return jsonObject.get("root");
    }

    private JsonObject parse(JsonObject record, JsonSchema schema) throws DataConversionException {
        JsonObject output = new JsonObject();
        for (int i = 0; i < schema.fieldsCount(); ++i) {
            JsonElement parsed;
            JsonSchema schemaElement = schema.getFieldSchemaAt(i);
            String columnKey = schemaElement.getColumnName();
            if (!record.has(columnKey)) {
                output.add(columnKey, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            JsonElement columnValue = record.get(columnKey);
            switch (schemaElement.getType()) {
                case UNION: {
                    parsed = this.parseUnionType(schemaElement, columnValue);
                    break;
                }
                case ENUM: {
                    parsed = this.parseEnumType(schemaElement, columnValue);
                    break;
                }
                default: {
                    parsed = columnValue.isJsonArray() ? this.parseJsonArrayType(schemaElement, columnValue) : (columnValue.isJsonObject() ? this.parseJsonObjectType(schemaElement, columnValue) : this.parsePrimitiveType(schemaElement, columnValue));
                }
            }
            output.add(columnKey, parsed);
        }
        return output;
    }

    private JsonElement parseUnionType(JsonSchema schemaElement, JsonElement columnValue) throws DataConversionException {
        try {
            return this.parse(columnValue, schemaElement.getFirstTypeSchema());
        }
        catch (DataConversionException e) {
            return this.parse(columnValue, schemaElement.getSecondTypeSchema());
        }
    }

    private JsonElement parseEnumType(JsonSchema schema, JsonElement value) throws DataConversionException {
        if (schema.getSymbols().contains(value)) {
            return value;
        }
        throw new DataConversionException("Invalid symbol: " + value.getAsString() + " allowed values: " + schema.getSymbols().toString());
    }

    private JsonElement parseJsonArrayType(JsonSchema schema, JsonElement value) throws DataConversionException {
        JsonElementConversionFactory.Type arrayType = schema.getTypeOfArrayItems();
        JsonArray tempArray = new JsonArray();
        if (JsonElementConversionFactory.Type.isPrimitive(arrayType)) {
            return value;
        }
        JsonSchema nestedSchema = schema.getItemsWithinDataType();
        for (JsonElement v : value.getAsJsonArray()) {
            tempArray.add(this.parse(v, nestedSchema));
        }
        return tempArray;
    }

    private JsonElement parseJsonObjectType(JsonSchema schema, JsonElement value) throws DataConversionException {
        JsonSchema valuesWithinDataType = schema.getValuesWithinDataType();
        if (schema.isType(JsonElementConversionFactory.Type.MAP)) {
            if (JsonElementConversionFactory.Type.isPrimitive(valuesWithinDataType.getType())) {
                return value;
            }
            JsonObject map = new JsonObject();
            for (Map.Entry mapEntry : value.getAsJsonObject().entrySet()) {
                JsonElement mapValue = (JsonElement)mapEntry.getValue();
                map.add((String)mapEntry.getKey(), this.parse(mapValue, valuesWithinDataType));
            }
            return map;
        }
        if (schema.isType(JsonElementConversionFactory.Type.RECORD)) {
            JsonSchema schemaArray = valuesWithinDataType.getValuesWithinDataType();
            return this.parse((JsonObject)value, schemaArray);
        }
        return JsonNull.INSTANCE;
    }

    private JsonElement parsePrimitiveType(JsonSchema schema, JsonElement value) throws DataConversionException {
        if ((schema.isType(JsonElementConversionFactory.Type.NULL) || schema.isNullable()) && value.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (schema.isType(JsonElementConversionFactory.Type.NULL) && !value.isJsonNull() || !schema.isType(JsonElementConversionFactory.Type.NULL) && value.isJsonNull()) {
            throw new DataConversionException("Type mismatch for " + value.toString() + " of type " + schema.getDataTypes().toString());
        }
        if (schema.isType(JsonElementConversionFactory.Type.FIXED)) {
            int expectedSize = schema.getSizeOfFixedData();
            if (value.getAsString().length() == expectedSize) {
                return value;
            }
            throw new DataConversionException("Fixed type value is not same as defined value expected fieldsCount: " + expectedSize);
        }
        return value;
    }
}

