/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinMetricsPinotFlattenerConverter
extends Converter<Schema, Schema, GenericRecord, GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(GobblinMetricsPinotFlattenerConverter.class);
    private final Schema schema;

    public GobblinMetricsPinotFlattenerConverter() throws IOException {
        try (InputStream is = GobblinMetricsPinotFlattenerConverter.class.getClassLoader().getResourceAsStream("FlatGobblinMetric.avsc");){
            this.schema = new Schema.Parser().parse(is);
        }
    }

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return this.schema;
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        GenericRecordBuilder baseBuilder = new GenericRecordBuilder(this.schema);
        Map tags = (Map)inputRecord.get("tags");
        ArrayList tagList = Lists.newArrayList((Iterable)Iterables.transform(tags.entrySet(), (Function)new Function<Map.Entry<Utf8, Utf8>, String>(){

            public String apply(Map.Entry<Utf8, Utf8> input) {
                return input.getKey().toString() + ":" + input.getValue().toString();
            }
        }));
        baseBuilder.set("tags", (Object)tagList);
        baseBuilder.set("timestamp", inputRecord.get("timestamp"));
        List metrics = (List)inputRecord.get("metrics");
        ArrayList flatMetrics = Lists.newArrayList();
        for (GenericRecord metric : metrics) {
            GenericRecordBuilder thisMetric = new GenericRecordBuilder(baseBuilder);
            thisMetric.set("metricName", metric.get("name"));
            thisMetric.set("metricValue", metric.get("value"));
            flatMetrics.add(thisMetric.build());
        }
        return flatMetrics;
    }
}

