/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.util;

import com.linkedin.r2.util.ClosableQueue;
import com.linkedin.r2.util.TimeoutExecutor;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timeout<T>
implements TimeoutExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(Timeout.class);
    private final AtomicReference<T> _item;
    private final ScheduledFuture<?> _future;
    private final ClosableQueue<Runnable> _queue = new ClosableQueue();

    public Timeout(ScheduledExecutorService executor, long timeout, TimeUnit timeoutUnit, T item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this._item = new AtomicReference<T>(item);
        this._future = executor.schedule(new Runnable(){

            @Override
            public void run() {
                Object item = Timeout.this._item.getAndSet(null);
                if (item != null) {
                    List actions = Timeout.this._queue.close();
                    if (actions.isEmpty()) {
                        LOG.warn("Timeout elapsed but no action was specified");
                    }
                    for (Runnable action : actions) {
                        try {
                            action.run();
                        }
                        catch (Exception e) {
                            LOG.error("Failed to execute timeout action", (Throwable)e);
                        }
                    }
                }
            }
        }, timeout, timeoutUnit);
    }

    public T getItem() {
        T item = this._item.getAndSet(null);
        if (item != null) {
            this._future.cancel(false);
        }
        return item;
    }

    @Override
    public void addTimeoutTask(Runnable action) {
        if (!this._queue.offer(action)) {
            action.run();
        }
    }
}

