/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class WireAttributeHelper {
    private static final String WIRE_ATTR_PREFIX = "X-LI-R2-W-";

    public static Map<String, String> removeWireAttributes(Map<String, String> map) {
        TreeMap<String, String> wireAttrs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.toUpperCase().startsWith(WIRE_ATTR_PREFIX)) continue;
            String value = entry.getValue();
            String newKey = key.substring(WIRE_ATTR_PREFIX.length());
            wireAttrs.put(newKey, value);
            it.remove();
        }
        return wireAttrs;
    }

    public static Map<String, String> toWireAttributes(Map<String, String> attrs) {
        TreeMap<String, String> wireAttrs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            String key = WIRE_ATTR_PREFIX + entry.getKey();
            String value = entry.getValue();
            wireAttrs.put(key, value);
        }
        return wireAttrs;
    }
}

