/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.rest;

import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;

public class RestException
extends RemoteInvocationException {
    private static final long serialVersionUID = 1L;
    private final RestResponse _response;

    public RestException(RestResponse response) {
        super(response.getEntity().asAvroString());
        this._response = response;
    }

    public RestException(RestResponse response, Throwable cause) {
        super(cause);
        this._response = response;
    }

    public RestException(RestResponse response, String message, Throwable cause) {
        super(message, cause);
        this._response = response;
    }

    public RestException(RestResponse response, String message) {
        super(message);
        this._response = response;
    }

    public RestResponse getResponse() {
        return this._response;
    }

    @Override
    public String toString() {
        return "RestException{_response=" + this._response + "} ";
    }

    public static RestException forError(int status, Throwable throwable) {
        return new RestException(RestStatus.responseForError(status, throwable), throwable);
    }

    public static RestException forError(int status, String detail) {
        return new RestException(RestStatus.responseForStatus(status, detail));
    }
}

