/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.TreeMap;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTunnelUtil {
    private static final String HEADER_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final String MULTIPART = "multipart/mixed";
    private static final String MIXED = "mixed";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String UTF8 = "UTF-8";
    static final Logger LOG = LoggerFactory.getLogger(QueryTunnelUtil.class);

    private QueryTunnelUtil() {
    }

    public static RestRequest encode(RestRequest request, int threshold) throws URISyntaxException, MessagingException, IOException {
        return QueryTunnelUtil.encode(request, new RequestContext(), threshold);
    }

    public static RestRequest encode(RestRequest request, RequestContext requestContext, int threshold) throws URISyntaxException, MessagingException, IOException {
        boolean forceQueryTunnel;
        URI uri = request.getURI();
        String query = uri.getRawQuery();
        boolean bl = forceQueryTunnel = requestContext.getLocalAttr("FORCE_QUERY_TUNNEL") != null && (Boolean)requestContext.getLocalAttr("FORCE_QUERY_TUNNEL") != false;
        if (query == null || query.length() == 0 || query.length() < threshold && !forceQueryTunnel) {
            return request;
        }
        return QueryTunnelUtil.doEncode(request);
    }

    private static RestRequest doEncode(RestRequest request) throws URISyntaxException, MessagingException, IOException {
        RestRequestBuilder requestBuilder = new RestRequestBuilder(request);
        URI uri = request.getURI();
        URI newUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, uri.getFragment());
        ByteString entity = request.getEntity();
        if (entity == null || entity.length() == 0) {
            requestBuilder.setHeader(HEADER_CONTENT_TYPE, FORM_URL_ENCODED);
            requestBuilder.setEntity(ByteString.copyString((String)uri.getRawQuery(), (Charset)Data.UTF_8_CHARSET));
        } else {
            MimeMultipart multi = QueryTunnelUtil.createMultiPartEntity(entity, request.getHeader(HEADER_CONTENT_TYPE), uri.getRawQuery());
            requestBuilder.setHeader(HEADER_CONTENT_TYPE, multi.getContentType());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            multi.writeTo((OutputStream)os);
            requestBuilder.setEntity(ByteString.copy((byte[])os.toByteArray()));
        }
        requestBuilder.setURI(newUri);
        requestBuilder.setHeader(HEADER_METHOD_OVERRIDE, requestBuilder.getMethod());
        requestBuilder.setHeader(CONTENT_LENGTH, Integer.toString(requestBuilder.getEntity().length()));
        requestBuilder.setMethod("POST");
        return requestBuilder.build();
    }

    public static void encode(StreamRequest request, int threshold, Callback<StreamRequest> callback) {
        QueryTunnelUtil.encode(request, new RequestContext(), threshold, callback);
    }

    public static void encode(StreamRequest request, RequestContext requestContext, int threshold, final Callback<StreamRequest> callback) {
        boolean forceQueryTunnel;
        URI uri = request.getURI();
        String query = uri.getRawQuery();
        boolean bl = forceQueryTunnel = requestContext.getLocalAttr("FORCE_QUERY_TUNNEL") != null && (Boolean)requestContext.getLocalAttr("FORCE_QUERY_TUNNEL") != false;
        if (query == null || query.length() == 0 || query.length() < threshold && !forceQueryTunnel) {
            callback.onSuccess((Object)request);
        } else {
            Messages.toRestRequest(request, new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                }

                public void onSuccess(RestRequest result) {
                    RestRequest encodedRequest;
                    try {
                        encodedRequest = QueryTunnelUtil.doEncode(result);
                    }
                    catch (Exception ex) {
                        callback.onError((Throwable)ex);
                        return;
                    }
                    callback.onSuccess((Object)Messages.toStreamRequest(encodedRequest));
                }
            });
        }
    }

    public static RestRequest decode(RestRequest request) throws MessagingException, IOException, URISyntaxException {
        return QueryTunnelUtil.decode(request, new RequestContext());
    }

    public static RestRequest decode(RestRequest request, RequestContext requestContext) throws MessagingException, IOException, URISyntaxException {
        if (request.getHeader(HEADER_METHOD_OVERRIDE) == null) {
            return request;
        }
        return QueryTunnelUtil.doDecode(request, requestContext);
    }

    private static RestRequest doDecode(final RestRequest request, RequestContext requestContext) throws MessagingException, IOException, URISyntaxException {
        String query = null;
        byte[] entity = new byte[]{};
        ContentType contentType = new ContentType(request.getHeader(HEADER_CONTENT_TYPE));
        RestRequestBuilder requestBuilder = request.builder();
        TreeMap<String, String> h = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        h.putAll(request.getHeaders());
        h.remove(HEADER_METHOD_OVERRIDE);
        if (contentType.getBaseType().equals(FORM_URL_ENCODED)) {
            query = request.getEntity().asString(Data.UTF_8_CHARSET);
            h.remove(HEADER_CONTENT_TYPE);
            h.remove(CONTENT_LENGTH);
        } else if (contentType.getBaseType().equals(MULTIPART)) {
            h.remove(HEADER_CONTENT_TYPE);
            h.remove(CONTENT_LENGTH);
            MimeMultipart multi = new MimeMultipart(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return request.getEntity().asInputStream();
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getContentType() {
                    return request.getHeader(QueryTunnelUtil.HEADER_CONTENT_TYPE);
                }

                public String getName() {
                    return null;
                }
            });
            for (int i = 0; i < multi.getCount(); ++i) {
                MimeBodyPart part = (MimeBodyPart)multi.getBodyPart(i);
                if (part.isMimeType(FORM_URL_ENCODED) && query == null) {
                    query = IOUtil.toString((InputStream)part.getContent(), UTF8);
                    continue;
                }
                if (entity.length <= 0) {
                    Object content = part.getContent();
                    if (content instanceof MimeMultipart) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ((MimeMultipart)content).writeTo((OutputStream)os);
                        entity = os.toByteArray();
                    } else {
                        entity = IOUtil.toByteArray((InputStream)content);
                    }
                    h.put(CONTENT_LENGTH, Integer.toString(entity.length));
                    h.put(HEADER_CONTENT_TYPE, part.getContentType());
                    continue;
                }
                String unexpectedContentType = part.getContentType();
                LOG.warn("Unexpected body part in X-HTTP-Method-Override request, type=" + unexpectedContentType);
            }
        }
        if (query != null && query.length() > 0) {
            String separator = "&";
            String existingQuery = request.getURI().getRawQuery();
            if (existingQuery == null) {
                separator = "?";
            } else if (existingQuery.isEmpty()) {
                separator = "";
            }
            requestBuilder.setURI(new URI(request.getURI().toString() + separator + query));
        }
        requestBuilder.setEntity(entity);
        requestBuilder.setHeaders(h);
        requestBuilder.setMethod(request.getHeader(HEADER_METHOD_OVERRIDE));
        requestContext.putLocalAttr("IS_QUERY_TUNNELED", true);
        return requestBuilder.build();
    }

    public static void decode(StreamRequest request, Callback<StreamRequest> callback) {
        QueryTunnelUtil.decode(request, new RequestContext(), callback);
    }

    public static void decode(StreamRequest request, final RequestContext requestContext, final Callback<StreamRequest> callback) {
        if (request.getHeader(HEADER_METHOD_OVERRIDE) == null) {
            callback.onSuccess((Object)request);
        } else {
            Messages.toRestRequest(request, new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                }

                public void onSuccess(RestRequest result) {
                    RestRequest decodedRequest;
                    try {
                        decodedRequest = QueryTunnelUtil.doDecode(result, requestContext);
                    }
                    catch (Exception ex) {
                        callback.onError((Throwable)ex);
                        return;
                    }
                    callback.onSuccess((Object)Messages.toStreamRequest(decodedRequest));
                }
            });
        }
    }

    private static MimeMultipart createMultiPartEntity(final ByteString entity, final String entityContentType, String query) throws MessagingException {
        MimeMultipart multi = new MimeMultipart(MIXED);
        MimeBodyPart dataPart = new MimeBodyPart();
        ContentType contentType = new ContentType(entityContentType);
        if (MULTIPART.equals(contentType.getBaseType())) {
            MimeMultipart nested = new MimeMultipart(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return entity.asInputStream();
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getContentType() {
                    return entityContentType;
                }

                public String getName() {
                    return null;
                }
            });
            dataPart.setContent((Object)nested, contentType.getBaseType());
        } else {
            dataPart.setContent((Object)entity.copyBytes(), contentType.getBaseType());
        }
        dataPart.setHeader(HEADER_CONTENT_TYPE, entityContentType);
        MimeBodyPart argPart = new MimeBodyPart();
        argPart.setContent((Object)query, FORM_URL_ENCODED);
        argPart.setHeader(HEADER_CONTENT_TYPE, FORM_URL_ENCODED);
        multi.addBodyPart((BodyPart)argPart);
        multi.addBodyPart((BodyPart)dataPart);
        return multi;
    }
}

