/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.QueryTunnelUtil;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.util.Map;

public class ClientQueryTunnelFilter
implements RestFilter,
StreamFilter {
    private final int _queryPostThreshold;

    public ClientQueryTunnelFilter(int queryPostThreshold) {
        this._queryPostThreshold = queryPostThreshold;
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        RestRequest newReq;
        try {
            newReq = QueryTunnelUtil.encode(req, requestContext, this._queryPostThreshold);
        }
        catch (Exception e) {
            nextFilter.onError(e, requestContext, wireAttrs);
            return;
        }
        nextFilter.onRequest(newReq, requestContext, wireAttrs);
    }

    @Override
    public void onStreamRequest(StreamRequest req, final RequestContext requestContext, final Map<String, String> wireAttrs, final NextFilter<StreamRequest, StreamResponse> nextFilter) {
        Callback<StreamRequest> callback = new Callback<StreamRequest>(){

            public void onError(Throwable e) {
                nextFilter.onError(e, requestContext, wireAttrs);
            }

            public void onSuccess(StreamRequest newReq) {
                nextFilter.onRequest(newReq, requestContext, wireAttrs);
            }
        };
        QueryTunnelUtil.encode(req, requestContext, this._queryPostThreshold, callback);
    }
}

